package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract.*
import com.instabug.library.internal.storage.cache.dbv2.IBGEncryptedDbVersions.DB_V7

class DBMigrationV7(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {

    override val previous: BaseDbMigration by lazy { DBMigrationV6(db) }

    override val version: Int
        get() = DB_V7

    override fun execute() = runLogic {
        with(db) {
            execSQL(FatalHangEntry.DROP_TABLE)
            execSQL(FatalHangEntry.CREATE_TABLE)
            execSQL(SessionEntry.CREATE_TABLE)
            execSQL(SessionExperimentEntry.CREATE_TABLE)
        }
    }
}