package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract
import com.instabug.library.internal.storage.cache.dbv2.IBGEncryptedDbVersions.DB_V4

class DBMigrationV4(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {
    override val previous: BaseDbMigration? by lazy { DBMigrationV3(db) }
    override val version: Int
        get() = DB_V4

    override fun execute() = runLogic { db.execSQL(IBGDbContract.FatalHangEntry.CREATE_TABLE) }
}