package com.instabug.library.internal.storage.cache.db.migrations;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;

import androidx.annotation.NonNull;

import com.instabug.library.Constants;
import com.instabug.library.Instabug;
import com.instabug.library.internal.storage.AttachmentManager;
import com.instabug.library.internal.storage.cache.db.InstabugDBVersions;
import com.instabug.library.internal.storage.cache.db.InstabugDbContract;
import com.instabug.library.util.InstabugSDKLogger;

import java.io.File;

/**
 * Allows the database to migrate from version 20 to version 21
 * <p>
 * No Schemas changes, it is only to fix https://instabug.atlassian.net/browse/INSD-4634
 *
 * @see InstabugDBVersions
 */
public class Migration_20_21 implements Migration {

    @Override
    public void migrate(SQLiteDatabase db) {
        InstabugSDKLogger.d(Constants.LOG_TAG, "migration 20_21");
        if (Instabug.getApplicationContext() == null) return;

        clearBugsAndCrashesTables(db);

        clearInstabugAttachmentDirectory(Instabug.getApplicationContext());
    }

    private void clearBugsAndCrashesTables(SQLiteDatabase db) {
        if (db == null) return;
        InstabugSDKLogger.d(Constants.LOG_TAG, "clearBugsAndCrashesTables");

        // clearing bugs & crashes tables
        db.execSQL("DELETE FROM " + InstabugDbContract.CrashEntry.TABLE_NAME);
        db.execSQL("DELETE FROM " + InstabugDbContract.BugEntry.TABLE_NAME);
    }

    private void clearInstabugAttachmentDirectory(@NonNull Context applicationContext) {
        InstabugSDKLogger.d(Constants.LOG_TAG, "clearInstabugAttachmentDirectory started");
        File attachmentDirectory = AttachmentManager.getAttachmentDirectory(applicationContext, false);
        if (attachmentDirectory == null) {
            return;
        }

        AttachmentManager.deleteRecursive(attachmentDirectory);
        InstabugSDKLogger.d(Constants.LOG_TAG, "clearInstabugAttachmentDirectory finished");

    }
}
