package com.instabug.library.internal.storage.cache.db

import android.annotation.SuppressLint
import android.database.sqlite.SQLiteDatabase
import com.instabug.library.safetyUse

private const val COLUMN_NAME = "name"
private const val QUERY_TABLE_COLUMNS = "PRAGMA table_info('%s')"
private const val QUERY_TABLE = "SELECT name FROM sqlite_master WHERE type='table' AND name='%s'"

object MigrationUtilities {

    @SuppressLint("Recycle")
    fun SQLiteDatabase.columnExists(table: String, column: String) = runCatching {
        var exists = false
        rawQuery(QUERY_TABLE_COLUMNS.format(table), null)?.safetyUse{ cursor ->
            cursor.moveToFirst()
            do {
                if (cursor.run { getString(getColumnIndexOrThrow(COLUMN_NAME)) } != column) continue
                exists = true
                break
            } while (cursor.moveToNext())
        }; exists
    }.getOrDefault(false)

    @SuppressLint("Recycle")
    fun SQLiteDatabase.tableExists(table: String) = runCatching {
        rawQuery(QUERY_TABLE.format(table), null)?.safetyUse {
            it.count != 0
        } ?: false
    }.getOrDefault(false)
}