package com.instabug.library.internal.servicelocator.application;

import com.instabug.library.internal.servicelocator.InitialContext;
import com.instabug.library.internal.servicelocator.ServiceLocator;
import com.instabug.library.internal.servicelocator.ServiceRegistry;
import com.instabug.library.internal.servicelocator.SingleInstanceServiceRegistry;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;

@RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
public class ApplicationServiceLocator {

    private static final ServiceLocator SERVICE_LOCATOR;

    static {
        InitialContext initialContext = new ApplicationInitialContext();
        ServiceRegistry registry = new SingleInstanceServiceRegistry();
        SERVICE_LOCATOR = ServiceLocator.getInstance(initialContext, registry);
    }

    @NonNull
    @RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
    public static ServiceLocator get() {
        return SERVICE_LOCATOR;
    }
}
