package com.instabug.library.internal.sdkexperiments

import com.instabug.library.internal.sharedpreferences.corePercentagePref
import com.instabug.library.percentagefeatures.resolvePercentages
import org.json.JSONObject

fun interface SDKExperimentConfigurator {
    fun handleConfigs(configs: JSONObject)
}

interface SDKExperiment<Out> : SDKExperimentConfigurator {
    fun getImplementation(): Out
}

open class PercentageSDKExperiment<Out>(
    prefKey: String,
    private val configKey: String,
    private val factory: ImplementationFactory<Out>
) : SDKExperiment<Out> {

    private var expConfig by corePercentagePref(prefKey)

    override fun handleConfigs(configs: JSONObject) {
        configs.optDouble(configKey, 0.0)
            .let { percentage -> expConfig?.apply { resolvePercentages(percentage) } }
            .also { newConfig -> expConfig = newConfig }
    }

    override fun getImplementation(): Out =
        takeIf { (expConfig?.isEnabled ?: false) }
            ?.let { factory.createExperimental() }
            ?: factory.createLegacy()
}
