package com.instabug.library.internal;

import android.Manifest;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;

import androidx.annotation.Nullable;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;

/**
 * Static class to hold media projection intent to avoid showing the permission dialog multiple times.
 */
public class InstabugMediaProjectionIntent {
    @Nullable
    private static Intent mediaProjectionIntent;
    private static int staticResultCode;
    private static boolean isMediaProjectionIntentUsed = false;

    private InstabugMediaProjectionIntent() {
    }

    public static void setMediaProjectionIntent(@Nullable Intent mediaProjectionIntent) {
        InstabugMediaProjectionIntent.mediaProjectionIntent = mediaProjectionIntent;
        setMediaProjectionIntentUsed(false);
    }

    @Nullable
    public static Intent getMediaProjectionIntent() {
        return mediaProjectionIntent;
    }
    public static void setMediaProjectionIntentUsed(boolean isMediaProjectionIntentUsed) {
        InstabugMediaProjectionIntent.isMediaProjectionIntentUsed = isMediaProjectionIntentUsed;
    }


    public static void release() {
        setMediaProjectionIntentUsed(false);
        mediaProjectionIntent = null;
        staticResultCode = -1;
    }

    public static void setStaticResultCode(int staticResultCode) {
        InstabugMediaProjectionIntent.staticResultCode = staticResultCode;
    }

    public static int getStaticResultCode() {
        return staticResultCode;
    }

    /**
     * Check if the media projection intent is available to be used/reused or not.
     * This API was introduced in response to the android 14 (API-34) changes for the
     * media projection intent reusing limitations.
     * So, now the acquired media projection intent is valid to be used one time only and
     * you required to request the user consent again if you want to use media projection functionalities.
     */
    public static boolean isMediaProjectionIntentReadyToUse() {
        return  mediaProjectionIntent != null
                && (!isMediaProjectionIntentUsed || Build.VERSION.SDK_INT < Build.VERSION_CODES.UPSIDE_DOWN_CAKE);
    }

    public static boolean canStartMediaProjectionFGService(Context context) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.UPSIDE_DOWN_CAKE) {
            boolean isMediaProtectionServicePermissionExist = context
                    .checkSelfPermission(Manifest.permission.FOREGROUND_SERVICE_MEDIA_PROJECTION) == PackageManager.PERMISSION_GRANTED;
            if (!isMediaProtectionServicePermissionExist) {
                InstabugSDKLogger.e(Constants.LOG_TAG, "Can't found FOREGROUND_SERVICE_MEDIA_PROJECTION permission!");
                return false;
            }
        }
        return true;
    }
}
