package com.instabug.library.encryption.iv

import androidx.annotation.VisibleForTesting
import com.instabug.library.util.InstabugSDKLogger

object StaticIVProvider {

    private const val TAG = "StaticIVProvider"

    init {
        try {
            System.loadLibrary("ibg-native")
        } catch (e: UnsatisfiedLinkError) {
            InstabugSDKLogger.e(TAG, "Error loading native library", e)
        }
    }

    @JvmStatic
    fun getStaticIV(): ByteArray {
        var ivLength = 0
        try {
            val ivNative: String = getIVString()
            ivLength = ivNative.length
            val result = ByteArray(ivLength)
            System.arraycopy(
                ivNative.toByteArray(),
                0,
                result,
                0,
                ivLength
            )
            return result
        } catch (e: Exception) {
            InstabugSDKLogger.e(TAG, "Error loading native initialization vector", e)
        }

        return ByteArray(ivLength)
    }

    @JvmStatic
    @VisibleForTesting
    external fun getIVString(): String
}