package com.instabug.library.diagnostics.sdkEvents.configurations

import android.content.SharedPreferences
import com.instabug.library.diagnostics.sdkEvents.configurations.SDKEventConfigs.Companion.ALLOW_LIST_KEY
import com.instabug.library.diagnostics.sdkEvents.configurations.SDKEventConfigs.Companion.FEATURE_NAME
import com.instabug.library.settings.SettingsManager

internal class SDKEventConfigsImpl(
    private val settingsManager: SettingsManager,
    private val sharedPreferences: SharedPreferences?,
) : SDKEventConfigs {
    override val isEnabled: Boolean
       get() = settingsManager.isFeatureEnabled(FEATURE_NAME, false)

    override val allowList: Set<String>?
        get() = sharedPreferences?.getStringSet(ALLOW_LIST_KEY, null)
}