package com.instabug.library.diagnostics.nonfatals.cache;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;

import com.instabug.library.diagnostics.nonfatals.model.Occurrence;

import java.util.List;


/**
 * Created by Shannan on 31/08/2021.
 */
public interface OccurrencesDBHelper {

    int NOT_FOUND = -1;

    /**
     * Saves Occurrence to non_fatal_occurrence table
     *
     * @param Occurrence instance to be saved
     * @return true if saved, false otherwise
     */
    @WorkerThread
    boolean insertOccurrence(@NonNull Occurrence Occurrence);

    /**
     * trim saved Occurrences to limit
     *
     * @param limit limit to trim to
     */
    @WorkerThread
    void trimToLimit(int limit);

    /**
     * Gets count of all cached occurrences of a non-fatal
     *
     * @param nonFatalId the id of the nonFatal
     * @return count of occurrences
     */
    @WorkerThread
    int getNonFatalOccurrencesCount(long nonFatalId);

    /**
     * Gets list of all cached occurrences of a non-fatal
     *
     * @param nonFatalId the id of the nonFatal
     * @return list of occurrences
     */
    @WorkerThread
    @NonNull
    List<Occurrence> getNonFatalOccurrences(long nonFatalId);

    /**
     * Gets list of all cached occurrences
     *
     * @return list of occurrences
     */
    @WorkerThread
    @NonNull
    List<Occurrence> getAllOccurrences();

    /**
     * Updates non-fatal contents
     *
     * @param occurrence object to be updated
     */
    @WorkerThread
    void update(Occurrence occurrence);

    /**
     * Delete all saved occurrences of a non-fatal
     *
     * @param nonFatalId the id of the nonFatal
     */
    @WorkerThread
    void clearNonFatalOccurrences(int nonFatalId);

    /**
     * Delete all saved occurrences
     */
    @WorkerThread
    void clearAll();


    /**
     * Gets all state files URIs for non fatal
     *
     * @param id non fatal id
     * @return array of state files URIs
     */
    @WorkerThread
    @Nullable
    String[] getStateFilesForNonFatal(long id);

    @WorkerThread
    List<String> getStateFiles();

    @WorkerThread
    void deleteOccurrence(String stateFileUri);
}
