package com.instabug.library.diagnostics.nonfatals.cache;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;

import com.instabug.library.diagnostics.nonfatals.model.NonFatal;
import com.instabug.library.diagnostics.nonfatals.model.Occurrence;

import java.util.List;

public interface NonFatalCacheManager {

     String NON_FATAL_STATE = "non_fatal_state";

    /**
     * Caches the reported non-fatal to db
     *
     * @param nonFatal the non-fatal to be cached
     */
    @WorkerThread
    void saveNonFatal(@NonNull NonFatal nonFatal);


    /**
     *  Saves a list of non-fatals to the db
     *
     * @param nonFatals: the non-fatals to be saved
     * @return list of saved non-fatals' ids
     */
    @WorkerThread
    List<Long> saveNonFatals(@NonNull List<NonFatal> nonFatals);

    /**
     * Gets list of all cached non-fatals
     *
     * @return list of non-fatal
     */
    @NonNull
    List<NonFatal> getAllNonFatals();

    /**
     * Gets list of all cached occurrences of a non-fatal
     *
     * @param nonFatalId the id of the nonFatal
     * @return list of occurrences
     */
    @NonNull
    List<Occurrence> getNonFatalOccurrences(long nonFatalId);


    /**
     * Save occurrence to occurrences table
     * @param occurrence
     */
    @WorkerThread
    void saveOccurrence(Occurrence occurrence);

    /**
     * Clears all non-fatals cache
     */
    @WorkerThread
    void clearCache();


    @WorkerThread
    List<Occurrence> getAllOccurrences();

    List<String> getStateFilesForAllOccurrences();

    void deleteNonFatal(long id);

    void deleteOccurrence(@Nullable String stateFileUri);

}
