package com.instabug.library.diagnostics.customtraces.settings

import androidx.annotation.VisibleForTesting
import com.instabug.library.diagnostics.DiagnosticsConstants
import com.instabug.library.diagnostics.configuration.ConfigurationChangedHandler
import com.instabug.library.diagnostics.customtraces.di.CustomTracesServiceLocator
import com.instabug.library.percentagefeatures.IBGPercentageFlagsResolver
import com.instabug.library.settings.PersistableSettings
import org.json.JSONObject

object TracesConfigurationHandler : ConfigurationChangedHandler {

    @VisibleForTesting
    const val TRACES_DEFAULT_PERCENTAGE = 0.0
    @VisibleForTesting
    const val LAUNCH_TRACES_DEFAULT_PERCENTAGE = 0.0
    @VisibleForTesting
    const val FEATURE_TRACES_DEFAULT_PERCENTAGE = 0.0

    override fun onConfigurationChanged(json: JSONObject?) {
        json?.optJSONObject(DiagnosticsConstants.CUSTOM_TRACES)?.let { customTraces ->
            val customTracesPercentage =
                customTraces.optDouble(DiagnosticsConstants.ENABLED, TRACES_DEFAULT_PERCENTAGE)
            IBGPercentageFlagsResolver.resolve(
                DiagnosticsConstants.CUSTOM_TRACES,
                customTracesPercentage
            )

            val launchTracesPercentage = customTraces.optDouble(
                DiagnosticsConstants.RECORD_LAUNCH_TRACE,
                LAUNCH_TRACES_DEFAULT_PERCENTAGE
            )
            IBGPercentageFlagsResolver.resolve(
                DiagnosticsConstants.RECORD_LAUNCH_TRACE,
                launchTracesPercentage
            )

            val featureTracesPercentage = customTraces.optDouble(
                DiagnosticsConstants.RECORD_FEATURE_TRACE,
                FEATURE_TRACES_DEFAULT_PERCENTAGE
            )
            IBGPercentageFlagsResolver.resolve(
                DiagnosticsConstants.RECORD_FEATURE_TRACE,
                featureTracesPercentage
            )
            CustomTracesSettingsResolver.resolve(customTraces)
        } ?: run {
            PersistableSettings.getInstance()
                ?.clearPercentageFeature(DiagnosticsConstants.CUSTOM_TRACES)
            PersistableSettings.getInstance()
                ?.clearPercentageFeature(DiagnosticsConstants.RECORD_LAUNCH_TRACE)
            PersistableSettings.getInstance()
                ?.clearPercentageFeature(DiagnosticsConstants.RECORD_FEATURE_TRACE)
            CustomTracesSettingsResolver.resetCustomTracesSettings()
            CustomTracesServiceLocator.getCustomTracesManager().clearCache()
        }
    }
}