package com.instabug.library.core.eventbus.instabugeventbus

import com.instabug.library.core.eventbus.eventpublisher.IBGCompositeDisposable
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable
import com.instabug.library.core.eventbus.eventpublisher.Subscriber

abstract class AbstractOperatorEventBus<IN, OUT>(protected val source: InstabugEventBus<IN>) :
    InstabugEventBus<OUT>() {

    abstract fun handleEvent(event: IN)

    override fun subscribe(subscriber: Subscriber<OUT>): IBGDisposable = IBGCompositeDisposable()
        .apply {
            add(super.subscribe(subscriber))
            add(source.subscribe(::handleEvent))
        }
}