package com.instabug.library.core.eventbus.coreeventbus

import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable
import com.instabug.library.core.eventbus.eventpublisher.Subscriber
import com.instabug.library.core.eventbus.instabugeventbus.InstabugEventBus

//region IBGCoreEventBus Types

const val TYPE_V3_SESSION = "v3_session"
const val TYPE_NETWORK = "network"
const val TYPE_CP_CRASH = "cross_platform_crashed"
const val TYPE_CP_STATE_SCREEN_CHANGED = "cross_platform_state_screen_changed"
const val TYPE_SESSION = "session"
const val TYPE_USER = "user"
const val TYPE_FOREGROUNDS_STATUS = "foreground_status"
const val TYPE_CACHE_DUMP = "cache_dump"
const val TYPE_SDK_VERSION = "sdk_version"
const val TYPE_APP_TOKEN = "app_token"
const val TYPE_OS_VERSION = "os_version"
const val TYPE_FEATURES_FETCHED = "featuresFetched"
const val TYPE_FEATURES = "features"
const val TYPE_ENCRYPTION_STATE = "encryption_state"
const val TYPE_REPRO_STATE = "repro_state"
const val TYPE_CODE_PUSH_VERSION = "codepush_version"

//endregion

object IBGCoreEventBus : InstabugEventBus<IBGSdkCoreEvent>()
object IBGCoreEventPublisher {
    @JvmStatic
    fun post(event: IBGSdkCoreEvent) = IBGCoreEventBus.post(event)
}

object IBGCoreEventSubscriber {
    @JvmStatic
    fun subscribe(subscriber: Subscriber<IBGSdkCoreEvent>): IBGDisposable =
        IBGCoreEventBus.subscribe(subscriber)
}

sealed class IBGSdkCoreEvent(val type: String) {
    sealed class Session : IBGSdkCoreEvent(type = TYPE_SESSION) {
        object SessionStarted : Session()
        object SessionFinished : Session()
    }

    sealed class V3Session : IBGSdkCoreEvent(type = TYPE_V3_SESSION) {
        object V3SessionStarted : V3Session()
        class V3StartedInForeground(val startTime: Long, val uuid: String, val partialId: UInt) :
            V3Session()

        object V3SessionFinished : V3Session()
    }

    sealed class User : IBGSdkCoreEvent(type = TYPE_USER) {
        object LoggedIn : User()
        object LoggedOut : User()
    }

    sealed class Features : IBGSdkCoreEvent(type = TYPE_FEATURES) {
        object Fetched : Features()
        object Updated : Features()
    }

    object NetworkActivated : IBGSdkCoreEvent(type = TYPE_NETWORK)

    object ForegroundAvailable : IBGSdkCoreEvent(type = TYPE_FOREGROUNDS_STATUS)

    object CacheDumped : IBGSdkCoreEvent(type = TYPE_CACHE_DUMP)

    object OSVersionChanged : IBGSdkCoreEvent(type = TYPE_OS_VERSION)

    object AppTokenChanged : IBGSdkCoreEvent(type = TYPE_APP_TOKEN)

    object SdkVersionChanged : IBGSdkCoreEvent(type = TYPE_SDK_VERSION)

    object CrossPlatformCrashed : IBGSdkCoreEvent(type = TYPE_CP_CRASH)

    object EncryptionStateChanged : IBGSdkCoreEvent(TYPE_ENCRYPTION_STATE)

    class FeaturesFetched(val response: String) : IBGSdkCoreEvent(type = TYPE_FEATURES_FETCHED)

    class ReproState(val modesMap: Map<Int, Int>) : IBGSdkCoreEvent(type = TYPE_REPRO_STATE)

    object CodePushVersionChanged : IBGSdkCoreEvent(type = TYPE_CODE_PUSH_VERSION)

    /**
     * When creating a new SdkCoreEvent of this type, the value passed will always be the screenName
     * passed in {@link Instabug#reportScreenChange(Bitmap, String)}
     */
    class CrossPlatformScreenChanged(val screenName: String) :
        IBGSdkCoreEvent(type = TYPE_CP_STATE_SCREEN_CHANGED)
}
