package com.instabug.library

import androidx.annotation.StringDef

class IBGFeature {
    companion object {
        @StringDef(
            INSTABUG,
            PUSH_NOTIFICATION,
            WHITE_LABELING,
            CUSTOM_FONT,
            IN_APP_MESSAGING,
            TRACK_USER_STEPS,
            REPRO_STEPS,
            MULTIPLE_ATTACHMENTS,
            INSTABUG_LOGS,
            NETWORK_LOGS,
            USER_DATA,
            CONSOLE_LOGS,
            VIEW_HIERARCHY_V2,
            USER_EVENTS,
            DISCLAIMER,
            SESSION_PROFILER,
            FEATURE_REQUESTS,
            VP_CUSTOMIZATION,
            ANNOUNCEMENTS,
            BUG_REPORTING,
            REPLIES,
            BE_USER_ATTRIBUTES,
            VZ_MESSAGES_CUSTOM_APPRATING_UI,
            DATABASE_TRANSACTIONS_DISABLED,
            PRODUCTION_USAGE_DETECTION,
            ENCRYPTION,
            NON_FATAL_ERRORS,
            DB_ENCRYPTION,
            SDK_STITCHING,
            SCREEN_OFF_MONITOR,
            CRASHES_CUSTOM_IDENTIFIED_EMAIL,
            DISABLE_ON_LOW_MEMORY,
            V3_SESSION,
            SURVEYS,
            BE_DISABLE_SIGNING,
            BE_USERS_KEYS,
            DEVICE_PERFORMANCE_CLASS,
            RATING_DIALOG_DETECTION
        )
        @Retention(AnnotationRetention.SOURCE)
        annotation class IBGFeature

        const val INSTABUG = "INSTABUG"
        const val PUSH_NOTIFICATION = "PUSH_NOTIFICATION"
        const val WHITE_LABELING = "WHITE_LABELING"
        const val CUSTOM_FONT = "CUSTOM_FONT"
        const val IN_APP_MESSAGING = "IN_APP_MESSAGING"
        const val TRACK_USER_STEPS = "TRACK_USER_STEPS"
        const val REPRO_STEPS = "REPRO_STEPS"
        const val MULTIPLE_ATTACHMENTS = "MULTIPLE_ATTACHMENTS"
        const val INSTABUG_LOGS = "INSTABUG_LOGS"
        const val USER_DATA = "USER_DATA"
        const val CONSOLE_LOGS = "CONSOLE_LOGS"
        const val NETWORK_LOGS = "NETWORK_LOGS"
        const val VIEW_HIERARCHY_V2 = "VIEW_HIERARCHY_V2"
        const val USER_EVENTS = "USER_EVENTS"
        const val DISCLAIMER = "DISCLAIMER"
        const val SESSION_PROFILER = "SESSION_PROFILER"
        const val FEATURE_REQUESTS = "FEATURE_REQUESTS"
        const val VP_CUSTOMIZATION = "VP_CUSTOMIZATION"
        const val ANNOUNCEMENTS = "ANNOUNCEMENTS"
        const val BUG_REPORTING = "BUG_REPORTING"
        const val REPLIES = "REPLIES"
        const val BE_USER_ATTRIBUTES = "BE_USER_ATTRIBUTES"
        const val VZ_MESSAGES_CUSTOM_APPRATING_UI = "VZ_MESSAGES_CUSTOM_APPRATING_UI"
        const val DATABASE_TRANSACTIONS_DISABLED = "DATABASE_TRANSACTIONS_DISABLED"
        const val PRODUCTION_USAGE_DETECTION = "PRODUCTION_USAGE_DETECTION"
        const val ENCRYPTION = "ENCRYPTION"
        const val NON_FATAL_ERRORS = "NON_FATAL_ERRORS"
        const val DB_ENCRYPTION = "DB_ENCRYPTION"
        const val SDK_STITCHING = "SDK_STITCHING"
        const val SCREEN_OFF_MONITOR = "SCREEN_OFF_MONITOR"
        const val CRASHES_CUSTOM_IDENTIFIED_EMAIL = "CRASHES_CUSTOM_IDENTIFIED_EMAIL"
        const val DISABLE_ON_LOW_MEMORY = "DISABLE_ON_LOW_MEMORY"
        const val V3_SESSION = "V3_SESSION"
        const val SURVEYS = "SURVEYS"
        const val BE_DISABLE_SIGNING = "BE_DISABLE_SIGNING"
        const val BE_USERS_KEYS = "BE_USERS_KEYS"
        const val DEVICE_PERFORMANCE_CLASS = "DEVICE_PERFORMANCE_CLASS"
        const val RATING_DIALOG_DETECTION = "rating_dialog_detection"
    }
}

