/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.sessionprofiler.model.timeline;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.sessionprofiler.model.timeline.a;
import com.instabug.library.sessionprofiler.model.timeline.b;
import com.instabug.library.sessionprofiler.model.timeline.c;
import com.instabug.library.sessionprofiler.model.timeline.d;
import com.instabug.library.sessionprofiler.model.timeline.e;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONException;
import org.json.JSONObject;

public class SessionProfilerTimeline
implements Serializable {
    private static final long serialVersionUID = 1105162041950151401L;
    private static final int DURATION_TO_TRIM = 60000;
    public static final int TIME_INTERVAL_HIGH_FREQUENCY = 1000;
    public static final int TIME_INTERVAL_LOW_FREQUENCY = 2000;
    private static final int COUNT_OF_HIGH_FREQUENCY_ELEMENTS_IN_MINUTE = 60;
    private static final int COUNT_OF_LOW_FREQUENCY_ELEMENTS_IN_MINUTE = 30;
    private static final int VERSION_NUMBER = 1;
    private static final String KEY_PLATFORM = "platform";
    private static final String KEY_VERSION = "version";
    private static final String KEY_TIMELINE = "timeline";
    private static final String KEY_BATTERY = "battery";
    private static final String KEY_MEMORY = "memory";
    private static final String KEY_STORAGE = "storage";
    private static final String KEY_ORIENTATION = "orientation";
    private static final String KEY_CONNECTIVITY = "connectivity";
    private Queue<e> batteryStates = new ConcurrentLinkedQueue<e>();
    private Queue<e> connectivityStates = new ConcurrentLinkedQueue<e>();
    private Queue<e> orientationModes;
    private Queue<e> memoryUsages = new ConcurrentLinkedQueue<e>();
    private Queue<e> storageUsages = new ConcurrentLinkedQueue<e>();
    private final long totalStorage;

    public SessionProfilerTimeline() {
        this.orientationModes = new ConcurrentLinkedQueue<e>();
        this.totalStorage = DeviceStateProvider.getTotalStorage();
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public static void adjustTime(Collection<e> timelinePoints, float frequency) {
        ConcurrentLinkedQueue concurrentLinkedQueue;
        if (timelinePoints instanceof ConcurrentLinkedQueue) {
            concurrentLinkedQueue = concurrentLinkedQueue;
        } else {
            ConcurrentLinkedQueue concurrentLinkedQueue2;
            ConcurrentLinkedQueue concurrentLinkedQueue3 = concurrentLinkedQueue2;
            concurrentLinkedQueue2 = new ConcurrentLinkedQueue(concurrentLinkedQueue);
            concurrentLinkedQueue = concurrentLinkedQueue3;
        }
        int n2 = 0;
        for (e e2 : concurrentLinkedQueue) {
            void var1_2;
            double d2 = (double)Math.round((double)((long)((float)n2 / var1_2 * (float)SessionProfilerTimeline.getDurationToTrim())) / 10.0) / 100.0;
            if (e2 != null) {
                e2.a(d2);
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static Queue<e> trimQueue(Queue<e> src, int trimCount) {
        Queue<e> queue;
        void var1_1;
        while (src.size() > var1_1) {
            queue.poll();
        }
        return queue;
    }

    /*
     * WARNING - void declaration
     */
    private JSONObject getTimelineJSONObject(Collection<e> timelinePoints) throws JSONException {
        void var1_1;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(KEY_TIMELINE, (Object)e.a((Collection)var1_1));
        return jSONObject;
    }

    public static SessionProfilerTimeline fromJson(JSONObject jsonObject) {
        SessionProfilerTimeline sessionProfilerTimeline;
        SessionProfilerTimeline sessionProfilerTimeline2 = sessionProfilerTimeline;
        sessionProfilerTimeline2();
        try {
            JSONObject jSONObject;
            sessionProfilerTimeline2.batteryStates = a.a(jSONObject.getJSONObject(KEY_BATTERY).getJSONArray(KEY_TIMELINE));
            sessionProfilerTimeline2.connectivityStates = b.a(jSONObject.getJSONObject(KEY_CONNECTIVITY).getJSONArray(KEY_TIMELINE));
            sessionProfilerTimeline2.orientationModes = d.a(jSONObject.getJSONObject(KEY_ORIENTATION).getJSONArray(KEY_TIMELINE));
            sessionProfilerTimeline2.memoryUsages = c.a(jSONObject.getJSONObject(KEY_MEMORY).getJSONArray(KEY_TIMELINE));
            sessionProfilerTimeline.storageUsages = c.a(jSONObject.getJSONObject(KEY_STORAGE).getJSONArray(KEY_TIMELINE));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return sessionProfilerTimeline2;
    }

    private static int getDurationToTrim() {
        return CoreServiceLocator.getLimitConstraintApplier().applyConstraints(60000);
    }

    public static int getTimeIntervalHighFrequency() {
        return CoreServiceLocator.getLimitConstraintApplier().applyConstraints(1000);
    }

    public static int getTimeIntervalLowFrequency() {
        return CoreServiceLocator.getLimitConstraintApplier().applyConstraints(2000);
    }

    static int getCountOfHighFrequencyElements() {
        return CoreServiceLocator.getLimitConstraintApplier().applyConstraints(60);
    }

    static int getCountOfLowFrequencyElements() {
        return CoreServiceLocator.getLimitConstraintApplier().applyConstraints(30);
    }

    /*
     * WARNING - void declaration
     */
    public void addBatteryState(float value, boolean plugged) {
        void var2_2;
        void var1_1;
        this.batteryStates.add(new a((float)var1_1, (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void addBatteryState(@NonNull a state) {
        void var1_1;
        this.batteryStates.add((e)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addConnectivityState(b connectivityState) {
        void var1_1;
        this.connectivityStates.add((e)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addMemoryUsage(c usedMemory) {
        void var1_1;
        this.memoryUsages.add((e)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addStorageUsage(c usedStorage) {
        void var1_1;
        this.storageUsages.add((e)var1_1);
    }

    public long getTotalStorage() {
        return this.totalStorage;
    }

    /*
     * WARNING - void declaration
     */
    public void addScreenOrientation(d screenOrientation) {
        void var1_1;
        this.orientationModes.add((e)var1_1);
    }

    Queue<e> getBatteryStates() {
        return this.batteryStates;
    }

    Queue<e> getConnectivityStates() {
        return this.connectivityStates;
    }

    Queue<e> getOrientationModes() {
        return this.orientationModes;
    }

    Queue<e> getMemoryUsages() {
        return this.memoryUsages;
    }

    Queue<e> getStorageUsages() {
        return this.storageUsages;
    }

    public SessionProfilerTimeline trim() {
        return this.trim(1.0f);
    }

    /*
     * WARNING - void declaration
     */
    public SessionProfilerTimeline trim(float percentage) {
        void var1_1;
        SessionProfilerTimeline sessionProfilerTimeline = this;
        SessionProfilerTimeline sessionProfilerTimeline2 = sessionProfilerTimeline;
        SessionProfilerTimeline sessionProfilerTimeline3 = sessionProfilerTimeline;
        SessionProfilerTimeline sessionProfilerTimeline4 = sessionProfilerTimeline;
        SessionProfilerTimeline sessionProfilerTimeline5 = sessionProfilerTimeline;
        Queue<e> queue = sessionProfilerTimeline.batteryStates;
        float f2 = SessionProfilerTimeline.getCountOfLowFrequencyElements();
        SessionProfilerTimeline.trimQueue(queue, Math.round(f2 * var1_1));
        Queue<e> queue2 = sessionProfilerTimeline3.connectivityStates;
        float f3 = SessionProfilerTimeline.getCountOfLowFrequencyElements();
        SessionProfilerTimeline.trimQueue(queue2, Math.round(f3 * var1_1));
        Queue<e> queue3 = sessionProfilerTimeline4.orientationModes;
        float f4 = SessionProfilerTimeline.getCountOfLowFrequencyElements();
        SessionProfilerTimeline.trimQueue(queue3, Math.round(f4 * var1_1));
        Queue<e> queue4 = sessionProfilerTimeline5.memoryUsages;
        float f5 = SessionProfilerTimeline.getCountOfHighFrequencyElements();
        SessionProfilerTimeline.trimQueue(queue4, Math.round(f5 * var1_1));
        Queue<e> queue5 = sessionProfilerTimeline2.storageUsages;
        float f6 = SessionProfilerTimeline.getCountOfHighFrequencyElements();
        try {
            SessionProfilerTimeline.trimQueue(queue5, Math.round(f6 * var1_1));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugCore.reportError(outOfMemoryError, "OOM while trimming session profiler timeline");
            InstabugSDKLogger.e("IBG-Core", "OOM while trimming session profiler timeline", outOfMemoryError);
        }
        return this;
    }

    public JSONObject toJson() {
        JSONObject jSONObject;
        SessionProfilerTimeline sessionProfilerTimeline = this_;
        SessionProfilerTimeline.adjustTime(sessionProfilerTimeline.batteryStates, SessionProfilerTimeline.getCountOfLowFrequencyElements());
        SessionProfilerTimeline.adjustTime(sessionProfilerTimeline.connectivityStates, SessionProfilerTimeline.getCountOfLowFrequencyElements());
        SessionProfilerTimeline.adjustTime(sessionProfilerTimeline.orientationModes, SessionProfilerTimeline.getCountOfLowFrequencyElements());
        SessionProfilerTimeline.adjustTime(sessionProfilerTimeline.memoryUsages, SessionProfilerTimeline.getCountOfHighFrequencyElements());
        SessionProfilerTimeline.adjustTime(sessionProfilerTimeline.storageUsages, SessionProfilerTimeline.getCountOfHighFrequencyElements());
        JSONObject jSONObject2 = jSONObject;
        JSONObject jSONObject3 = new JSONObject().put(KEY_VERSION, 1).put(KEY_PLATFORM, (Object)"Android");
        SessionProfilerTimeline sessionProfilerTimeline2 = this_;
        SessionProfilerTimeline sessionProfilerTimeline3 = sessionProfilerTimeline2;
        SessionProfilerTimeline sessionProfilerTimeline4 = sessionProfilerTimeline2;
        String string2 = KEY_BATTERY;
        JSONObject jSONObject4 = jSONObject3.put(string2, (Object)sessionProfilerTimeline4.getTimelineJSONObject(sessionProfilerTimeline3.batteryStates));
        SessionProfilerTimeline sessionProfilerTimeline5 = this_;
        SessionProfilerTimeline sessionProfilerTimeline6 = sessionProfilerTimeline5;
        SessionProfilerTimeline sessionProfilerTimeline7 = sessionProfilerTimeline5;
        string2 = KEY_ORIENTATION;
        JSONObject jSONObject5 = jSONObject4.put(string2, (Object)sessionProfilerTimeline7.getTimelineJSONObject(sessionProfilerTimeline6.orientationModes));
        SessionProfilerTimeline sessionProfilerTimeline8 = this_;
        SessionProfilerTimeline sessionProfilerTimeline9 = sessionProfilerTimeline8;
        SessionProfilerTimeline sessionProfilerTimeline10 = sessionProfilerTimeline8;
        string2 = KEY_BATTERY;
        JSONObject jSONObject6 = jSONObject5.put(string2, (Object)sessionProfilerTimeline10.getTimelineJSONObject(sessionProfilerTimeline9.batteryStates));
        SessionProfilerTimeline sessionProfilerTimeline11 = this_;
        SessionProfilerTimeline sessionProfilerTimeline12 = sessionProfilerTimeline11;
        SessionProfilerTimeline sessionProfilerTimeline13 = sessionProfilerTimeline11;
        string2 = KEY_CONNECTIVITY;
        JSONObject jSONObject7 = jSONObject6.put(string2, (Object)sessionProfilerTimeline13.getTimelineJSONObject(sessionProfilerTimeline12.connectivityStates));
        SessionProfilerTimeline sessionProfilerTimeline14 = this_;
        SessionProfilerTimeline sessionProfilerTimeline15 = sessionProfilerTimeline14;
        SessionProfilerTimeline sessionProfilerTimeline16 = sessionProfilerTimeline14;
        string2 = KEY_MEMORY;
        JSONObject jSONObject8 = jSONObject7.put(string2, (Object)sessionProfilerTimeline16.getTimelineJSONObject(sessionProfilerTimeline15.memoryUsages));
        SessionProfilerTimeline sessionProfilerTimeline17 = this_;
        SessionProfilerTimeline sessionProfilerTimeline18 = sessionProfilerTimeline17;
        SessionProfilerTimeline sessionProfilerTimeline19 = sessionProfilerTimeline17;
        string2 = KEY_STORAGE;
        JSONObject jSONObject9 = sessionProfilerTimeline19.getTimelineJSONObject(sessionProfilerTimeline18.storageUsages);
        SessionProfilerTimeline sessionProfilerTimeline20 = this_;
        String this_ = "total";
        long l2 = sessionProfilerTimeline20.getTotalStorage();
        try {
            jSONObject8.put(string2, (Object)jSONObject9.put(this_, l2));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject2;
    }
}

