/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.logging;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.apichecker.APIChecker;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.d;
import com.instabug.library.datahub.c;
import com.instabug.library.datahub.g;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.filestore.j;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.sessionreplay.model.a;
import com.instabug.library.sessionreplay.model.b;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.concurrent.ExecutionException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InstabugLog {
    public static final int INSTABUG_LOG_LIMIT = 1000;

    public static void v(String logMessage) {
        APIChecker.checkAndRunInExecutor("InstabugLog.v", () -> {
            String string2;
            if (InstabugLog.isInstabugLogsDisabled()) {
                return;
            }
            InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(LogLevel.V).setLogMessageDate(InstabugLog.getDate()));
        });
    }

    public static void d(String logMessage) {
        APIChecker.checkAndRunInExecutor("InstabugLog.d", () -> {
            String string2;
            if (InstabugLog.isInstabugLogsDisabled()) {
                return;
            }
            InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(LogLevel.D).setLogMessageDate(InstabugLog.getDate()));
        });
    }

    public static void i(String logMessage) {
        APIChecker.checkAndRunInExecutor("InstabugLog.i", () -> {
            String string2;
            if (InstabugLog.isInstabugLogsDisabled()) {
                return;
            }
            InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(LogLevel.I).setLogMessageDate(InstabugLog.getDate()));
        });
    }

    public static void e(String logMessage) {
        APIChecker.checkAndRunInExecutor("InstabugLog.e", () -> {
            String string2;
            if (InstabugLog.isInstabugLogsDisabled()) {
                return;
            }
            InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(LogLevel.E).setLogMessageDate(InstabugLog.getDate()));
        });
    }

    public static void w(String logMessage) {
        APIChecker.checkAndRunInExecutor("InstabugLog.w", () -> {
            String string2;
            if (InstabugLog.isInstabugLogsDisabled()) {
                return;
            }
            InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(LogLevel.W).setLogMessageDate(InstabugLog.getDate()));
        });
    }

    public static void wtf(String logMessage) {
        APIChecker.checkAndRunInExecutor("InstabugLog.wtf", () -> {
            String string2;
            if (InstabugLog.isInstabugLogsDisabled()) {
                return;
            }
            InstabugLog.addLog(new LogMessage().setLogMessage(string2).setLogMessageLevel(LogLevel.WTF).setLogMessageDate(InstabugLog.getDate()));
        });
    }

    public static void clearLogs() {
        InstabugLog.clearLogMessages();
    }

    public static String getLogs() {
        return InstabugLog.getLogMessages();
    }

    private static synchronized void addLog(LogMessage logMessage) {
        LogMessage logMessage2;
        CoreServiceLocator.getIbgLogsDistributor().invoke(logMessage2);
    }

    private static void clearLogMessages() {
        CoreServiceLocator.getIbgLogStore().clear();
    }

    private static String getLogMessages() {
        String string2;
        block6: {
            OutOfMemoryError outOfMemoryError2;
            block9: {
                InterruptedException interruptedException2;
                block8: {
                    com.instabug.library.internal.filestore.a a2;
                    string2 = "[]";
                    g g2 = CoreServiceLocator.getIbgLogStore();
                    j j2 = new j();
                    com.instabug.library.internal.filestore.a a3 = a2;
                    a2 = new com.instabug.library.internal.filestore.a();
                    a3 = (JSONArray)g2.a(j2, a3).get();
                    if (a3 == null) break block6;
                    try {
                        string2 = a3.toString();
                        break block6;
                    }
                    catch (ExecutionException executionException) {
                    }
                    catch (InterruptedException interruptedException2) {
                        break block8;
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        break block9;
                    }
                    InstabugCore.reportError(executionException, "Error retrieving log messages from store");
                    InstabugSDKLogger.e("IBG-Core", "Error retrieving log messages from store", executionException);
                    break block6;
                }
                InstabugSDKLogger.e("IBG-Core", "Error while getting log messages", interruptedException2);
                Thread.currentThread().interrupt();
                break block6;
            }
            InstabugCore.reportError(outOfMemoryError2, "Couldn't parse Instabug logs due to an OOM");
            InstabugSDKLogger.e("IBG-Core", "Couldn't parse Instabug logs due to an OOM", outOfMemoryError2);
        }
        return string2;
    }

    private static long getDate() {
        return InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds();
    }

    private static boolean isInstabugLogsDisabled() {
        return d.d().b((Object)"INSTABUG_LOGS") == Feature.State.DISABLED;
    }

    public static class LogMessage
    implements a,
    c {
        static final String KEY_LOG_MESSAGE = "log_message";
        static final String KEY_LOG_MESSAGE_LEVEL = "log_message_level";
        static final String KEY_LOG_MESSAGE_DATE = "log_message_date";
        public static final String FAILED_TO_PARSE_INSTABUG_LOG_TO_JSON = "Failed to parse Instabug Log to JSON:";
        public static final String TRIMMING_SUSFIX = "...";
        public static final String NULL_LOG = "null";
        @Nullable
        private String logMessage;
        @Nullable
        private LogLevel logMessageLevel;
        private long logMessageDate;

        @NonNull
        private String validateSize(@Nullable String logMessage) {
            String string2;
            if (logMessage == null) {
                return NULL_LOG;
            }
            int n2 = b.a(this);
            if (string2.length() > n2) {
                string2 = string2.substring(0, n2) + TRIMMING_SUSFIX;
            }
            return string2;
        }

        /*
         * WARNING - void declaration
         */
        public static LogMessage generateLogMessage(String message, LogLevel level) {
            void var1_1;
            String string2;
            return new LogMessage().setLogMessage(string2).setLogMessageLevel((LogLevel)var1_1).setLogMessageDate(InstabugLog.getDate());
        }

        @Nullable
        String getLogMessage() {
            return this.logMessage;
        }

        /*
         * WARNING - void declaration
         */
        LogMessage setLogMessage(String logMessage) {
            void var1_1;
            LogMessage logMessage2 = this;
            logMessage2.logMessage = logMessage2.validateSize((String)var1_1);
            return logMessage2;
        }

        @Nullable
        LogLevel getLogMessageLevel() {
            return this.logMessageLevel;
        }

        /*
         * WARNING - void declaration
         */
        LogMessage setLogMessageLevel(LogLevel logMessageLevel) {
            void var1_1;
            this.logMessageLevel = var1_1;
            return this;
        }

        long getLogMessageDate() {
            return this.logMessageDate;
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        public LogMessage setLogMessageDate(long logMessageDate) {
            void var1_1;
            this.logMessageDate = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
        public JSONObject toJson() {
            JSONException jSONException2;
            JSONObject jSONObject;
            block4: {
                JSONObject jSONObject2;
                jSONObject = jSONObject2;
                jSONObject();
                try {
                    String string2 = KEY_LOG_MESSAGE;
                    jSONObject2.put(string2, (Object)((LogMessage)((Object)this_)).getLogMessage());
                }
                catch (JSONException jSONException2) {}
                if (((LogMessage)((Object)this_)).getLogMessageLevel() == null) break block4;
                jSONObject.put(KEY_LOG_MESSAGE_LEVEL, (Object)((LogMessage)((Object)this_)).getLogMessageLevel().toString());
            }
            LogMessage logMessage = this_;
            String this_ = KEY_LOG_MESSAGE_DATE;
            long l2 = logMessage.getLogMessageDate();
            jSONObject.put(this_, l2);
            return jSONObject;
            InstabugSDKLogger.e("IBG-Core", "Error while parsing instabug logs", jSONException2);
            return jSONObject;
        }

        public long getTimestamp() {
            return this.getLogMessageDate();
        }

        @Override
        @NonNull
        public String getLogType() {
            return "IBG_LOG";
        }

        @Override
        @Nullable
        public JSONObject getSrJsonRep() {
            String string2;
            LogMessage logMessage;
            JSONObject jSONObject;
            JSONObject jSONObject2;
            try {
                JSONObject jSONObject3 = ((LogMessage)((Object)this_)).toJson();
                jSONObject2 = jSONObject3;
                jSONObject = jSONObject3;
                logMessage = this_;
                string2 = "log_type";
            }
            catch (JSONException jSONException) {
                IBGDiagnostics.reportNonFatalAndLog(jSONException, FAILED_TO_PARSE_INSTABUG_LOG_TO_JSON, "IBG-Core");
                return null;
            }
            JSONObject jSONObject4 = jSONObject2.put(string2, (Object)logMessage.getLogType());
            LogMessage logMessage2 = this_;
            String this_ = "timestamp";
            long l2 = logMessage2.getTimestamp();
            jSONObject4.put(this_, l2);
            return jSONObject;
        }

        @Override
        @Nullable
        public JSONObject getDataHubRep() {
            return this.toJson();
        }
    }

    public static enum LogLevel {
        V("v"),
        D("d"),
        I("i"),
        E("e"),
        W("w"),
        WTF("wtf");

        private final String level;

        /*
         * WARNING - void declaration
         */
        private LogLevel(String level) {
            void var3_3;
            this.level = var3_3;
        }

        @NonNull
        public String toString() {
            return this.level;
        }
    }
}

