/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Process;
import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.instabug.library.R;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugThemeResolver;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.StatusBarUtils;
import com.instabug.library.util.UiUtils;

public abstract class BaseFragmentActivity<P extends BaseContract.Presenter>
extends AppCompatActivity
implements _InstabugActivity,
BaseContract.View<AppCompatActivity> {
    private static final String IB_PID = "INSTABUG_PROCESS_ID";
    @Nullable
    protected P presenter;

    /*
     * WARNING - void declaration
     */
    public void onCreate(@Nullable Bundle savedInstanceState) {
        void var1_1;
        BaseFragmentActivity baseFragmentActivity = this;
        BaseFragmentActivity baseFragmentActivity2 = this;
        StatusBarUtils.setStatusBar((Activity)baseFragmentActivity2);
        LocaleUtils.setLocale((Activity)baseFragmentActivity2, InstabugCore.getLocale((Context)baseFragmentActivity2));
        super.onCreate((Bundle)var1_1);
        baseFragmentActivity.setTheme(InstabugThemeResolver.resolveTheme(SettingsManager.getInstance().getTheme()));
        if (InstabugCore.isFullScreen()) {
            UiUtils.showInFullscreen(this.getWindow());
        }
        BaseFragmentActivity baseFragmentActivity3 = this;
        baseFragmentActivity3.setContentView(baseFragmentActivity3.getLayout());
        baseFragmentActivity3.initViews();
        baseFragmentActivity3.getWindow().getDecorView().setId(R.id.instabug_decor_view);
    }

    public void onStart() {
        super.onStart();
    }

    protected void onResume() {
        Intent intent;
        BaseFragmentActivity baseFragmentActivity = this_;
        super.onResume();
        BaseFragmentActivity this_ = intent;
        new Intent().setAction("SDK invoked");
        this_.putExtra("SDK invoking state", true);
        LocalBroadcastManager.getInstance((Context)baseFragmentActivity).sendBroadcast((Intent)this_);
    }

    protected void onPause() {
        Intent intent;
        BaseFragmentActivity baseFragmentActivity = this_;
        super.onPause();
        BaseFragmentActivity this_ = intent;
        new Intent().setAction("SDK invoked");
        this_.putExtra("SDK invoking state", false);
        LocalBroadcastManager.getInstance((Context)baseFragmentActivity).sendBroadcast((Intent)this_);
    }

    public void onStop() {
        BaseFragmentActivity baseFragmentActivity = this;
        LocaleUtils.setAppLocale((Activity)baseFragmentActivity);
        super.onStop();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    public AppCompatActivity getViewContext() {
        return this;
    }

    @Override
    public void finishActivity() {
        this.finish();
    }

    @LayoutRes
    protected abstract int getLayout();

    protected abstract void initViews();

    /*
     * WARNING - void declaration
     */
    protected void onSaveInstanceState(Bundle outState) {
        void var1_1;
        super.onSaveInstanceState((Bundle)var1_1);
        outState.putInt(IB_PID, Process.myPid());
    }

    /*
     * WARNING - void declaration
     */
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        void var1_1;
        super.onRestoreInstanceState((Bundle)var1_1);
        if (savedInstanceState != null && var1_1.getInt(IB_PID, -1) != Process.myPid()) {
            this.finishActivity();
        }
    }
}

