/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.networkv2.request;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.networkv2.request.AppTokenProvider;
import com.instabug.library.networkv2.request.Constants;
import com.instabug.library.networkv2.request.FileToUpload;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.networkv2.request.a;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tokenmapping.TokenMappingServiceLocator;
import com.instabug.library.user.e;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Request {
    private static final String SHORTEN_APP_TOKEN = "at";
    private static final String SHORTEN_UUID = "uid";
    private static final String APP_TOKEN = "application_token";
    private static final String UUID = "uuid";
    public static final String BASIC_AUTH_VALUE_PREFIX = "Basic ";
    @Nullable
    @VisibleForTesting
    String appTokenValue;
    private final String uuidValue;
    private final String sdkVersionValue;
    private final String requestUrl;
    @Nullable
    private final String endPoint;
    @Nullable
    private final String requestMethod;
    private final int requestType;
    private final List<RequestParameter> urlParameters;
    private final List<RequestParameter> bodyParameters;
    private final List<RequestParameter<String>> headers;
    @Nullable
    private final FileToUpload fileToUpload;
    @Nullable
    private final File downloadedFile;
    @Nullable
    private final JSONObject requestBodyJsonObject;
    private final boolean shorten;
    private boolean hasUuid;
    private boolean noDefaultParameters;

    /*
     * WARNING - void declaration
     */
    public Request(Builder builder) {
        ArrayList arrayList;
        void var1_1;
        String string2;
        Builder builder2 = builder;
        this.appTokenValue = null;
        this.uuidValue = e.i();
        this.sdkVersionValue = DeviceStateProvider.getSdkVersion();
        this.hasUuid = true;
        this.noDefaultParameters = false;
        this.endPoint = string2 = builder2.endpoint;
        string2 = builder2.requestUrl != null ? ((Builder)var1_1).requestUrl : Constants.BASE_URL + string2;
        this.requestUrl = string2;
        int n2 = ((Builder)var1_1).type != -1 ? ((Builder)var1_1).type : 1;
        void v12 = var1_1;
        this.requestType = n2;
        this.requestMethod = ((Builder)v12).method;
        this.fileToUpload = ((Builder)v12).fileToUpload;
        this.downloadedFile = ((Builder)v12).downloadedFile;
        this.requestBodyJsonObject = ((Builder)v12).requestBodyJsonObject;
        this.shorten = n2 = (int)(((Builder)v12).shorten ? 1 : 0);
        if (((Builder)v12).urlParameters != null) {
            arrayList = ((Builder)var1_1).urlParameters;
        } else {
            ArrayList arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList();
        }
        this.urlParameters = arrayList;
        if (((Builder)var1_1).bodyParameters != null) {
            arrayList = ((Builder)var1_1).bodyParameters;
        } else {
            ArrayList arrayList3;
            arrayList = arrayList3;
            arrayList3 = new ArrayList();
        }
        this.bodyParameters = arrayList;
        if (((Builder)var1_1).headers != null) {
            arrayList = ((Builder)var1_1).headers;
        } else {
            ArrayList arrayList4;
            arrayList = arrayList4;
            arrayList4 = new ArrayList();
        }
        void v5 = var1_1;
        this.headers = arrayList;
        this.hasUuid = ((Builder)v5).hasUuid;
        this.noDefaultParameters = ((Builder)v5).noDefaultParameters;
        this.appTokenValue = ((Builder)v5).tokenProvider.getAppToken();
        boolean bl = this.hasUuid;
        boolean bl2 = this.noDefaultParameters;
        this.handleBaseParams(n2 != 0, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private void handleBaseParams(boolean shorten, boolean hasUuid, boolean noDefaultParameters) {
        void var2_4;
        void var1_1;
        this.headers.add(new RequestParameter<String>("IBG-SDK-VERSION", this.sdkVersionValue));
        if (noDefaultParameters) {
            return;
        }
        if (var1_1 == false) {
            Object object = this.appTokenValue;
            if (object != null) {
                RequestParameter<String> requestParameter;
                RequestParameter<String> requestParameter2 = requestParameter;
                requestParameter = new RequestParameter<String>(APP_TOKEN, (String)object);
                this.addParameter(requestParameter2);
            }
            if (var2_4 != false) {
                RequestParameter<String> requestParameter;
                object = requestParameter;
                requestParameter = new RequestParameter<String>(UUID, this.uuidValue);
                this.addParameter((RequestParameter)object);
            }
        } else {
            Object object = this.appTokenValue;
            if (object != null) {
                RequestParameter<String> requestParameter;
                RequestParameter<String> requestParameter3 = requestParameter;
                requestParameter = new RequestParameter<String>(SHORTEN_APP_TOKEN, (String)object);
                this.addParameter(requestParameter3);
            }
            if (var2_4 != false) {
                RequestParameter<String> requestParameter;
                object = requestParameter;
                requestParameter = new RequestParameter<String>(SHORTEN_UUID, this.uuidValue);
                this.addParameter((RequestParameter)object);
            }
        }
    }

    private String getUrlEncodedParameters() {
        Request request = this_;
        a this_ = a.a();
        for (RequestParameter requestParameter : request.urlParameters) {
            this_.a(requestParameter.getKey(), requestParameter.getValue().toString());
        }
        return this_.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void addParameter(RequestParameter requestParameter) {
        String string2 = this.requestMethod;
        if (string2 != null) {
            void var1_1;
            if (!string2.equals("GET") && !this.requestMethod.equals("DELETE")) {
                this.addBodyParameter((RequestParameter)var1_1);
            } else {
                this.addUrlParameter((RequestParameter)var1_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addUrlParameter(RequestParameter parameter) {
        void var1_1;
        this.urlParameters.add((RequestParameter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void addBodyParameter(RequestParameter parameter) {
        void var1_1;
        this.bodyParameters.add((RequestParameter)var1_1);
    }

    @Nullable
    public String getEndpoint() {
        return this.endPoint;
    }

    public String getRequestUrl() {
        if (!this.getUrlEncodedParameters().isEmpty()) {
            return this.requestUrl + this.getUrlEncodedParameters();
        }
        return this.requestUrl;
    }

    public String getRequestUrlForLogging() {
        if (SettingsManager.shouldLogExtraRequestData() && !this.getUrlEncodedParameters().isEmpty()) {
            return this.requestUrl + this.getUrlEncodedParameters();
        }
        return this.requestUrl;
    }

    public String getRequestMethod() {
        String this_ = ((Request)((Object)this_)).requestMethod;
        if (this_ == null) {
            return "GET";
        }
        return this_;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public List<RequestParameter<String>> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public List<RequestParameter> getRequestUrlParameters() {
        return Collections.unmodifiableList(this.urlParameters);
    }

    public List<RequestParameter> getRequestBodyParameters() {
        return Collections.unmodifiableList(this.bodyParameters);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRequestBody() {
        void var0_3;
        JSONObject jSONObject = ((Request)this).requestBodyJsonObject;
        if (jSONObject == null) {
            JSONObject jSONObject2;
            jSONObject = jSONObject2;
            jSONObject2 = new JSONObject();
        }
        try {
            for (RequestParameter requestParameter : ((Request)this).getRequestBodyParameters()) {
                String string2 = requestParameter.getKey();
                jSONObject.put(string2, requestParameter.getValue());
            }
            return jSONObject.toString();
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (JSONException jSONException) {}
        JSONObject jSONObject3 = jSONObject;
        System.gc();
        InstabugSDKLogger.e("IBG-Core", "OOM Exception trying to remove large logs...", (Throwable)var0_3);
        var0_3.printStackTrace();
        try {
            jSONObject3.remove("console_log");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugSDKLogger.e("IBG-Core", "Failed to resolve OOM, returning empty request body", (Throwable)var0_3);
            outOfMemoryError.printStackTrace();
            return "{}";
        }
        {
            jSONObject3.remove("instabug_log");
        }
        {
            jSONObject3.remove("network_log");
        }
        return jSONObject3.toString();
    }

    @Nullable
    public FileToUpload getFileToUpload() {
        return this.fileToUpload;
    }

    @Nullable
    public File getDownloadedFile() {
        return this.downloadedFile;
    }

    public Builder builder() {
        return Builder.access$1500(Builder.access$1400(new Builder().endpoint(this.endPoint).url(this.requestUrl).method(this.requestMethod).type(this.requestType).shorten(this.shorten).fileToUpload(this.fileToUpload).fileToDownload(this.downloadedFile), this.bodyParameters), this.urlParameters).setHeaders(this.headers);
    }

    @NonNull
    public String toString() {
        String string2 = this.requestMethod;
        if (string2 != null && string2.equals("GET")) {
            return "Url: " + this.getRequestUrl() + " | Method: " + this.requestMethod;
        }
        return "Url: " + this.getRequestUrl() + " | Method: " + this.requestMethod + " | Body: " + this.getRequestBody();
    }

    public boolean isMultiPartRequest() {
        return this.fileToUpload != null;
    }

    public static class Builder {
        @Nullable
        private String requestUrl;
        @Nullable
        private String endpoint;
        @Nullable
        private String method;
        private int type;
        @Nullable
        private ArrayList<RequestParameter> urlParameters;
        @Nullable
        private ArrayList<RequestParameter> bodyParameters;
        @Nullable
        private ArrayList<RequestParameter<String>> headers;
        @Nullable
        private FileToUpload fileToUpload;
        @Nullable
        private File downloadedFile;
        @Nullable
        private JSONObject requestBodyJsonObject;
        private boolean shorten;
        private boolean hasUuid;
        private boolean noDefaultParameters;
        private AppTokenProvider tokenProvider;

        public Builder() {
            RequestParameter<String> requestParameter;
            RequestParameter<String> requestParameter2;
            RequestParameter<String> requestParameter3;
            AppTokenProvider appTokenProvider;
            Builder builder = this_;
            builder.type = -1;
            builder.hasUuid = true;
            builder.noDefaultParameters = false;
            AppTokenProvider appTokenProvider2 = appTokenProvider;
            appTokenProvider = new AppTokenProvider((Builder)this_){
                final /* synthetic */ Builder a;
                {
                    void var1_1;
                    this.a = var1_1;
                }

                @Override
                public String getAppToken() {
                    return TokenMappingServiceLocator.getTokenMappingConfigs().getAvailableAppToken();
                }
            };
            builder.tokenProvider = appTokenProvider2;
            Object this_ = requestParameter3;
            requestParameter3 = new RequestParameter<String>("IBG-OS", "android");
            builder.addHeader((RequestParameter<String>)this_);
            this_ = requestParameter2;
            requestParameter2 = new RequestParameter<String>("IBG-OS-VERSION", Build.VERSION.RELEASE);
            builder.addHeader((RequestParameter<String>)this_);
            this_ = requestParameter;
            requestParameter = new RequestParameter<String>("IBG-SDK-VERSION", DeviceStateProvider.getSdkVersion());
            builder.addHeader((RequestParameter<String>)this_);
        }

        /*
         * WARNING - void declaration
         */
        private Builder addUrlParameter(RequestParameter parameter) {
            void var1_1;
            if (this.urlParameters == null) {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList();
                this.urlParameters = arrayList2;
            }
            Builder builder = this;
            builder.urlParameters.add((RequestParameter)var1_1);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        private Builder setUrlParameter(List<RequestParameter> parameters) {
            void var1_1;
            ArrayList arrayList;
            if (((Builder)((Object)this_)).urlParameters == null) {
                ArrayList arrayList2;
                ArrayList arrayList3 = arrayList2;
                arrayList2 = new ArrayList();
                ((Builder)((Object)this_)).urlParameters = arrayList3;
            }
            Builder builder = this_;
            ArrayList this_ = arrayList;
            arrayList = new ArrayList(var1_1);
            builder.urlParameters = this_;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        private Builder addBodyParameter(RequestParameter parameter) {
            void var1_1;
            if (this.bodyParameters == null) {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList();
                this.bodyParameters = arrayList2;
            }
            Builder builder = this;
            builder.bodyParameters.add((RequestParameter)var1_1);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        private Builder setBodyParameter(List<RequestParameter> parameters) {
            void var1_1;
            ArrayList arrayList;
            if (((Builder)((Object)this_)).bodyParameters == null) {
                ArrayList arrayList2;
                ArrayList arrayList3 = arrayList2;
                arrayList2 = new ArrayList();
                ((Builder)((Object)this_)).bodyParameters = arrayList3;
            }
            Builder builder = this_;
            ArrayList this_ = arrayList;
            arrayList = new ArrayList(var1_1);
            builder.bodyParameters = this_;
            return builder;
        }

        private void addTokenToHeaders() {
            String string2 = ((Builder)((Object)this_)).tokenProvider.getAppToken();
            if (string2 != null) {
                RequestParameter<String> requestParameter;
                Builder builder = this_;
                RequestParameter<String> this_ = requestParameter;
                requestParameter = new RequestParameter<String>("IBG-APP-TOKEN", string2);
                builder.addHeader(this_);
            }
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Builder access$1400(Builder x02, List x12) {
            void var1_1;
            return x02.setBodyParameter((List<RequestParameter>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Builder access$1500(Builder x02, List x12) {
            void var1_1;
            return x02.setUrlParameter((List<RequestParameter>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public Builder tokenProvider(AppTokenProvider tokenProvider) {
            void var1_1;
            this.tokenProvider = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder url(String url) {
            void var1_1;
            this.requestUrl = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder endpoint(@Nullable String endpoint) {
            void var1_1;
            this.endpoint = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder method(@Nullable String requestMethod) {
            void var1_1;
            this.method = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder type(int requestType) {
            void var1_1;
            this.type = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder addParameter(RequestParameter requestParameter) {
            String string2 = this.method;
            if (string2 != null) {
                void var1_1;
                if (!string2.equals("GET") && !this.method.equals("DELETE")) {
                    this.addBodyParameter((RequestParameter)var1_1);
                } else {
                    this.addUrlParameter((RequestParameter)var1_1);
                }
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setParameter(List<RequestParameter> requestParameters) {
            String string2 = this.method;
            if (string2 != null) {
                void var1_1;
                if (!string2.equals("GET") && !this.method.equals("DELETE")) {
                    this.setBodyParameter((List<RequestParameter>)var1_1);
                } else {
                    this.setUrlParameter((List<RequestParameter>)var1_1);
                }
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder shorten(boolean isShortedKeys) {
            void var1_1;
            this.shorten = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder hasUuid(boolean hasUuid) {
            void var1_1;
            this.hasUuid = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder addHeader(RequestParameter<String> header) {
            void var1_1;
            if (this.headers == null) {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList();
                this.headers = arrayList2;
            }
            Builder builder = this;
            builder.headers.add((RequestParameter<String>)var1_1);
            return builder;
        }

        public Builder setHeaders(List<RequestParameter<String>> headers) {
            ArrayList arrayList;
            ArrayList arrayList2;
            if (headers == null) {
                ArrayList arrayList3;
                arrayList2 = arrayList3;
                arrayList3 = new ArrayList();
            }
            Builder builder = arrayList4;
            ArrayList arrayList4 = arrayList;
            arrayList = new ArrayList(arrayList2);
            builder.headers = arrayList4;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public Builder fileToUpload(@Nullable FileToUpload fileToUpload) {
            void var1_1;
            this.fileToUpload = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder fileToDownload(@Nullable File file) {
            void var1_1;
            this.downloadedFile = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder disableDefaultParameters(boolean noDefaultParameters) {
            void var1_1;
            this.noDefaultParameters = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setRequestBodyJsonObject(@Nullable JSONObject requestBodyJsonObject) {
            void var1_1;
            this.requestBodyJsonObject = var1_1;
            return this;
        }

        public Request build() {
            this.addTokenToHeaders();
            return new Request(this);
        }
    }

    public static interface Callbacks<T, K> {
        public void onSucceeded(T var1);

        public void onFailed(K var1);

        default public void onDisconnected() {
        }

        default public void onRetrying(Throwable throwable) {
        }
    }
}

