/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.sessionreplay.model.a;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserStep
implements Cacheable,
Serializable,
a {
    private static final String TAG = "UserStep";
    private static final String KEY_TIMESTAMP = "timestamp";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_TYPE = "type";
    private static final String KEY_ARGS = "args";
    private static final String SOMETHING_WENT_WRONG_WHILE_MAPPING_USER_STEP_TO_JSON_FOR_SR = "Something Went Wrong While mapping User Step to Json for SR";
    private long timeStamp;
    @Nullable
    private String message;
    @Nullable
    private Type type;
    @Nullable
    private Args args;

    public static ArrayList<UserStep> fromJson(JSONArray userStepsAsJsonArray) throws JSONException {
        JSONArray jSONArray;
        ArrayList<UserStep> arrayList;
        ArrayList<UserStep> arrayList2 = arrayList;
        arrayList = new ArrayList<UserStep>();
        if (userStepsAsJsonArray != null && jSONArray.length() > 0) {
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                UserStep userStep;
                UserStep userStep2 = userStep;
                userStep2();
                userStep.fromJson(jSONArray.getJSONObject(i2).toString());
                arrayList2.add(userStep);
            }
        }
        return arrayList2;
    }

    public static JSONArray toJson(@Nullable List<UserStep> userStepArrayList) {
        Iterator<UserStep> iterator;
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        if (userStepArrayList != null && iterator.size() > 0) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                UserStep userStep = (UserStep)iterator.next();
                try {
                    jSONArray2.put((Object)new JSONObject(userStep.toJson()));
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.v(TAG, ((Object)((Object)jSONException)).toString());
                }
            }
        }
        return jSONArray2;
    }

    @NonNull
    private JSONObject getJsonObject() throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        long l2 = this.getTimeStamp();
        jSONObject2.put(KEY_TIMESTAMP, l2);
        jSONObject.put(KEY_MESSAGE, (Object)this.getMessage());
        String string2 = KEY_TYPE;
        String string3 = this.getType() == null ? null : this.getType().toString();
        jSONObject2.put(string2, (Object)string3);
        if (this.getArgs() != null) {
            jSONObject2.put(KEY_ARGS, (Object)this.getArgs().toJson());
        }
        return jSONObject2;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeStamp(long timeStamp) {
        void var1_1;
        this.timeStamp = var1_1;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    /*
     * WARNING - void declaration
     */
    public void setMessage(@Nullable String message) {
        void var1_1;
        this.message = var1_1;
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public void setType(@Nullable Type type) {
        void var1_1;
        this.type = var1_1;
    }

    @Nullable
    public Args getArgs() {
        return this.args;
    }

    /*
     * WARNING - void declaration
     */
    public void setArgs(@Nullable Args args) {
        void var1_1;
        this.args = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setType(@Nullable String stepType) {
        if (stepType == null) {
            this.setType(Type.NOT_AVAILABLE);
        } else {
            void var1_1;
            int n2 = -1;
            switch (var1_1.hashCode()) {
                default: {
                    break;
                }
                case 1265144341: {
                    if (!var1_1.equals("DOUBLE_TAP")) break;
                    n2 = 7;
                    break;
                }
                case 1074528416: {
                    if (!var1_1.equals("LONG_PRESS")) break;
                    n2 = 6;
                    break;
                }
                case 79316762: {
                    if (!var1_1.equals("SWIPE")) break;
                    n2 = 5;
                    break;
                }
                case 78862054: {
                    if (!var1_1.equals("SHAKE")) break;
                    n2 = 4;
                    break;
                }
                case 76133530: {
                    if (!var1_1.equals("PINCH")) break;
                    n2 = 3;
                    break;
                }
                case 82819: {
                    if (!var1_1.equals("TAP")) break;
                    n2 = 2;
                    break;
                }
                case -1647502663: {
                    if (!var1_1.equals("APPLICATION_CREATED")) break;
                    n2 = 1;
                    break;
                }
                case -1854350643: {
                    if (!var1_1.equals("SCROLL")) break;
                    n2 = 0;
                }
            }
            switch (n2) {
                default: {
                    this.setType(Type.VIEW);
                    break;
                }
                case 7: {
                    this.setType(Type.DOUBLE_TAP);
                    break;
                }
                case 6: {
                    this.setType(Type.LONG_PRESS);
                    break;
                }
                case 5: {
                    this.setType(Type.SWIPE);
                    break;
                }
                case 4: {
                    this.setType(Type.MOTION);
                    break;
                }
                case 3: {
                    this.setType(Type.PINCH);
                    break;
                }
                case 2: {
                    this.setType(Type.TAP);
                    break;
                }
                case 1: {
                    this.setType(Type.APPLICATION);
                    break;
                }
                case 0: {
                    this.setType(Type.SCROLL);
                }
            }
        }
    }

    @Override
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String toJson() throws JSONException {
        return this.getJsonObject().toString();
    }

    @Override
    @Nullable
    public JSONObject getSrJsonRep() {
        UserStep userStep;
        JSONObject jSONObject;
        JSONObject jSONObject2;
        try {
            JSONObject jSONObject3 = ((UserStep)((Object)this_)).getJsonObject();
            jSONObject2 = jSONObject3;
            jSONObject = jSONObject3;
            userStep = this_;
            String this_ = "log_type";
        }
        catch (JSONException jSONException) {
            IBGDiagnostics.reportNonFatalAndLog(jSONException, SOMETHING_WENT_WRONG_WHILE_MAPPING_USER_STEP_TO_JSON_FOR_SR, "IBG-Core");
            return null;
        }
        jSONObject2.put(this_, (Object)userStep.getLogType());
        return jSONObject;
    }

    @Override
    public void fromJson(String modelAsJson) throws JSONException {
        Object object;
        JSONObject jSONObject;
        block32: {
            JSONObject jSONObject2;
            jSONObject = jSONObject2;
            if (new JSONObject((String)object).has(KEY_TIMESTAMP)) {
                if (StringUtility.isNumeric(jSONObject.getString(KEY_TIMESTAMP))) {
                    this.setTimeStamp(jSONObject.getLong(KEY_TIMESTAMP));
                } else {
                    object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US).parse(jSONObject.getString(KEY_TIMESTAMP));
                    if (object == null) break block32;
                    try {
                        this.setTimeStamp(((Date)object).getTime());
                    }
                    catch (ParseException parseException) {
                        InstabugSDKLogger.e(TAG, ((Object)parseException).toString());
                    }
                }
            }
        }
        if (jSONObject.has(KEY_MESSAGE)) {
            this.setMessage(jSONObject.getString(KEY_MESSAGE));
        }
        if (jSONObject.has(KEY_TYPE)) {
            object = jSONObject.getString(KEY_TYPE);
            ((String)object).hashCode();
            int n2 = -1;
            switch (((String)object).hashCode()) {
                default: {
                    break;
                }
                case 1554253136: {
                    if (!((String)object).equals("application")) break;
                    n2 = 8;
                    break;
                }
                case 779098677: {
                    if (!((String)object).equals("double_tap")) break;
                    n2 = 7;
                    break;
                }
                case 109854522: {
                    if (!((String)object).equals("swipe")) break;
                    n2 = 6;
                    break;
                }
                case 106671290: {
                    if (!((String)object).equals("pinch")) break;
                    n2 = 5;
                    break;
                }
                case 3619493: {
                    if (!((String)object).equals("view")) break;
                    n2 = 4;
                    break;
                }
                case 114595: {
                    if (!((String)object).equals("tap")) break;
                    n2 = 3;
                    break;
                }
                case -326696768: {
                    if (!((String)object).equals("long_press")) break;
                    n2 = 2;
                    break;
                }
                case -907680051: {
                    if (!((String)object).equals("scroll")) break;
                    n2 = 1;
                    break;
                }
                case -1068318794: {
                    if (!((String)object).equals("motion")) break;
                    n2 = 0;
                }
            }
            switch (n2) {
                default: {
                    this.setType(Type.NOT_AVAILABLE);
                    break;
                }
                case 8: {
                    this.setType(Type.APPLICATION);
                    break;
                }
                case 7: {
                    this.setType(Type.DOUBLE_TAP);
                    break;
                }
                case 6: {
                    this.setType(Type.SWIPE);
                    break;
                }
                case 5: {
                    this.setType(Type.PINCH);
                    break;
                }
                case 4: {
                    this.setType(Type.VIEW);
                    break;
                }
                case 3: {
                    this.setType(Type.TAP);
                    break;
                }
                case 2: {
                    this.setType(Type.LONG_PRESS);
                    break;
                }
                case 1: {
                    this.setType(Type.SCROLL);
                    break;
                }
                case 0: {
                    this.setType(Type.MOTION);
                }
            }
        }
        if (jSONObject.has(KEY_ARGS)) {
            Args args = new Args();
            args.fromJson(jSONObject.getString(KEY_ARGS));
            this.setArgs(args);
        }
    }

    @NonNull
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String toString() {
        return "UserStep{timeStamp='" + this.timeStamp + '\'' + ", message='" + this.message + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    public long getTimestamp() {
        return this.timeStamp;
    }

    @Override
    @NonNull
    public String getLogType() {
        return "USER_STEP";
    }

    public static enum Type {
        APPLICATION("application"),
        VIEW("view"),
        MOTION("motion"),
        TAP("tap"),
        PINCH("pinch"),
        LONG_PRESS("long_press"),
        SCROLL("scroll"),
        SWIPE("swipe"),
        DOUBLE_TAP("double_tap"),
        NOT_AVAILABLE("not_available");

        private final String name;

        /*
         * WARNING - void declaration
         */
        private Type(String name) {
            void var3_3;
            this.name = var3_3;
        }

        @NonNull
        public String toString() {
            return this.name;
        }
    }

    public static class Args
    implements Cacheable,
    Serializable {
        private static final String KEY_EVENT = "event";
        private static final String KEY_LABEL = "label";
        private static final String KEY_CLASS = "class";
        private static final String KEY_VIEW = "view";
        @Nullable
        private Type event;
        @Nullable
        private String label;
        @Nullable
        private String uiClass;
        @Nullable
        private String view;

        public Args() {
        }

        /*
         * WARNING - void declaration
         */
        public Args(@Nullable Type type, @Nullable String label, @Nullable String uiClass, @Nullable String view) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            Args args = this;
            args.setEvent((Type)var1_1);
            args.setLabel((String)var2_2);
            args.setUiClass((String)var3_3);
            args.setView((String)var4_4);
        }

        @Override
        @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
        public String toJson() throws JSONException {
            JSONObject jSONObject;
            JSONObject jSONObject2 = jSONObject;
            jSONObject2();
            jSONObject2.put(KEY_EVENT, (Object)this.getEvent());
            jSONObject2.put(KEY_LABEL, (Object)this.getLabel());
            jSONObject2.put(KEY_CLASS, (Object)this.getUiClass());
            jSONObject.put(KEY_VIEW, (Object)this.getView());
            return jSONObject.toString();
        }

        @Override
        public void fromJson(String modelAsJson) throws JSONException {
            String string2;
            JSONObject jSONObject;
            JSONObject jSONObject2 = jSONObject;
            if (new JSONObject(string2).has(KEY_EVENT)) {
                string2 = jSONObject2.getString(KEY_EVENT);
                string2.hashCode();
                int n2 = -1;
                switch (string2.hashCode()) {
                    default: {
                        break;
                    }
                    case 1554253136: {
                        if (!string2.equals("application")) break;
                        n2 = 8;
                        break;
                    }
                    case 779098677: {
                        if (!string2.equals("double_tap")) break;
                        n2 = 7;
                        break;
                    }
                    case 109854522: {
                        if (!string2.equals("swipe")) break;
                        n2 = 6;
                        break;
                    }
                    case 106671290: {
                        if (!string2.equals("pinch")) break;
                        n2 = 5;
                        break;
                    }
                    case 3619493: {
                        if (!string2.equals(KEY_VIEW)) break;
                        n2 = 4;
                        break;
                    }
                    case 114595: {
                        if (!string2.equals("tap")) break;
                        n2 = 3;
                        break;
                    }
                    case 110749: {
                        if (!string2.equals("pan")) break;
                        n2 = 2;
                        break;
                    }
                    case -907680051: {
                        if (!string2.equals("scroll")) break;
                        n2 = 1;
                        break;
                    }
                    case -1068318794: {
                        if (!string2.equals("motion")) break;
                        n2 = 0;
                    }
                }
                switch (n2) {
                    default: {
                        this.setEvent(Type.NOT_AVAILABLE);
                        break;
                    }
                    case 8: {
                        this.setEvent(Type.APPLICATION);
                        break;
                    }
                    case 7: {
                        this.setEvent(Type.DOUBLE_TAP);
                        break;
                    }
                    case 6: {
                        this.setEvent(Type.SWIPE);
                        break;
                    }
                    case 5: {
                        this.setEvent(Type.PINCH);
                        break;
                    }
                    case 4: {
                        this.setEvent(Type.VIEW);
                        break;
                    }
                    case 3: {
                        this.setEvent(Type.TAP);
                        break;
                    }
                    case 2: {
                        this.setEvent(Type.LONG_PRESS);
                        break;
                    }
                    case 1: {
                        this.setEvent(Type.SCROLL);
                        break;
                    }
                    case 0: {
                        this.setEvent(Type.MOTION);
                    }
                }
            }
            if (jSONObject2.has(KEY_CLASS)) {
                this.setUiClass(jSONObject2.getString(KEY_CLASS));
            }
            if (jSONObject2.has(KEY_LABEL)) {
                this.setLabel(jSONObject2.getString(KEY_LABEL));
            }
            if (jSONObject2.has(KEY_VIEW)) {
                this.setView(jSONObject2.getString(KEY_VIEW));
            }
        }

        @Nullable
        public Type getEvent() {
            return this.event;
        }

        /*
         * WARNING - void declaration
         */
        public void setEvent(@Nullable Type event) {
            void var1_1;
            this.event = var1_1;
        }

        @Nullable
        public String getLabel() {
            return this.label;
        }

        /*
         * WARNING - void declaration
         */
        public void setLabel(@Nullable String label) {
            void var1_1;
            this.label = var1_1;
        }

        @Nullable
        public String getUiClass() {
            return this.uiClass;
        }

        /*
         * WARNING - void declaration
         */
        public void setUiClass(@Nullable String uiClass) {
            void var1_1;
            this.uiClass = var1_1;
        }

        @Nullable
        public String getView() {
            return this.view;
        }

        /*
         * WARNING - void declaration
         */
        public void setView(@Nullable String view) {
            void var1_1;
            this.view = var1_1;
        }
    }
}

