package com.instabug.library.visualusersteps;

import static com.instabug.library.model.StepType.ACTIVITY_RESUMED;
import static com.instabug.library.model.StepType.COMPOSE_RESUMED;
import static com.instabug.library.model.StepType.FRAGMENT_RESUMED;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.model.StepType;

import java.util.Deque;
import java.util.concurrent.LinkedBlockingDeque;

/**
 * Created by tarek on 1/10/18.
 */

public class Parent {

    @Nullable
    @StepType
    private String type;
    private String id;
    @Nullable
    private String screenName;
    @Nullable
    private Screenshot screenshot;
    private Deque<VisualUserStep> steps;
    private boolean hasOnResumeStep;
    private volatile boolean isCapturingScreenShot = false;
    private volatile boolean isScreenSecured = false;
    private boolean isManuallyInvoked = false;

    Parent(String id, @Nullable String screenName, @Nullable @StepType String type) {
        this.id = id;
        this.screenName = screenName;
        steps = new LinkedBlockingDeque<>();
        this.type = type;
    }

    public void setType(@NonNull @StepType String type){
        this.type = type;
    }

    public void setScreenName(@Nullable String screenName) {
        this.screenName = screenName;
    }

    @Nullable
    public String getScreenName() {
        return screenName;
    }

    @Nullable
    @StepType
    public String getType() {
        return type;
    }

    void addStep(VisualUserStep step) {
        steps.add(step);
        if (step.getStepType() != null && (step.getStepType().equals(ACTIVITY_RESUMED)
                || step.getStepType().equals(FRAGMENT_RESUMED) || step.getStepType().equals(COMPOSE_RESUMED))) {
            hasOnResumeStep = true;
        }
    }

    Deque<VisualUserStep> getSteps() {
        return steps;
    }

    int getStepsCount() {
        return steps.size();
    }

    void removeFirst() {
        if (!steps.isEmpty())
            steps.pollFirst();
    }

    void removeLast() {
        if (!steps.isEmpty()) {
            steps.pollLast();
        }
    }

    public String getId() {
        return id;
    }

    public void setScreenshot(@Nullable Screenshot screenshot) {
        this.screenshot = screenshot;
    }

    @Nullable
    public Screenshot getScreenshot() {
        return screenshot;
    }

    boolean hasOnResumeStep() {
        return hasOnResumeStep;
    }

    public void setHasOnResumeStep(boolean hasOnResumeStep) {
        this.hasOnResumeStep = hasOnResumeStep;
    }

    @Nullable
    VisualUserStep getLastStep() {
        if (steps != null && steps.size() > 0)
            return steps.peekLast();
        else
            return null;
    }

    public boolean isCapturingScreenShot() {
        return isCapturingScreenShot;
    }

    public void setCapturingScreenShot(boolean capturingScreenShot) {
        isCapturingScreenShot = capturingScreenShot;
    }

    public boolean isScreenSecured() {
        return isScreenSecured;
    }

    public void setScreenSecured(boolean screenSecured) {
        isScreenSecured = screenSecured;
    }

    public void setManuallyInvoked() {
        this.isManuallyInvoked = true;
    }

    public boolean isManuallyInvoked() {
        return this.isManuallyInvoked;
    }

    public static class Screenshot {

        @Nullable
        private String id;
        @Nullable
        private String viewOrientation;

        public Screenshot(@Nullable String id) {
            this.id = id;
        }

        @Nullable
        public String getId() {
            return id;
        }

        public void setViewOrientation(@Nullable String viewOrientation) {
            this.viewOrientation = viewOrientation;
        }

        public void setId(@Nullable String id) {
            this.id = id;
        }

        @Nullable
        @VisualUserStep.ViewOrientation.Orientation
        public String getViewOrientation() {
            return viewOrientation;
        }

    }
}
