package com.instabug.library.util.threading;

import static android.os.Process.setThreadPriority;

import android.annotation.SuppressLint;

import androidx.annotation.Nullable;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;

public class PriorityThreadFactory extends IBGThreadFactory {

    private final int threadPriority;

    public PriorityThreadFactory(String identifier, int threadPriority) {
        super(identifier);
        this.threadPriority = threadPriority;
    }

    @SuppressLint("ERADICATE_INCONSISTENT_SUBCLASS_RETURN_ANNOTATION")
    @Nullable
    @Override
    public Thread newThread(final Runnable runnable) {
        Runnable wrapperRunnable = () -> {
            try {
                setThreadPriority(threadPriority);
                runnable.run();
            } catch (Throwable throwable) {
                InstabugSDKLogger.e(Constants.LOG_TAG,
                        "Creating new thread (" + getIdentifier() + ") threw an exception: " + throwable);
            }
        };
        try {
            return super.newThread(wrapperRunnable);
        } catch (Throwable throwable) {
            return null;
        }
    }

}