package com.instabug.library.util.filters;

import com.instabug.library.util.filters.actions.Action;
import com.instabug.library.util.filters.actions.ReturnableAction;

/**
 * A convenient class that helps chaining a series of filters to a certain element and either
 * return or consume the result
 *
 * @param <T> the type of item is to be filtered
 */
public class Filters<T> {

    private T t;

    private Filters(T t) {
        this.t = t;
    }

    /**
     * A fluent way of creating a filter chain
     *
     * @param t the item the filters will be applied on
     * @return a filters-chaining-ready Filters object
     */
    public static <T> Filters<T> applyOn(T t) {
        return new Filters<>(t);
    }

    /**
     * Applies the passed filter on the current item state and updates its state
     *
     * @param filter the filter to be applied
     * @return same filters chain
     */
    public Filters<T> apply(Filter<T> filter) {
        t = filter.apply(t);
        return this;
    }

    /**
     * @return current item state
     */
    public T thenGet() {
        return t;
    }

    /**
     * Consumes the current item state
     *
     * @param action the action that will consume the item
     */
    public void thenDo(Action<T> action) {
        action.apply(t);
    }

    /**
     * Convenient method for returning different outcome of the filter chain
     *
     * @param action the action that will consume the item
     * @return the returnable action result
     */
    public <N> N thenDoReturn(ReturnableAction<T, N> action) {
        return action.apply(t);
    }
}
