package com.instabug.library.util.extenstions

import com.instabug.library.Constants
import com.instabug.library.util.threading.OrderedExecutorService
import java.util.concurrent.Future

inline fun <Out> OrderedExecutorService.defensiveSubmit(
    key: String,
    errorMessage: String? = null,
    tag: String = Constants.LOG_TAG,
    crossinline block: () -> Out
): Future<Out?> = submit(key) {
    runOrLogError(tag, errorMessage) { block() }.getOrNull()
}

inline fun <Out> OrderedExecutorService.defensiveExecute(
    key: String,
    errorMessage: String? = null,
    tag: String = Constants.LOG_TAG,
    crossinline block: () -> Out
): Unit = execute(key) {
    runOrLogError(tag, errorMessage) { block() }.getOrNull()
}