package com.instabug.library.usersteps;

import android.annotation.SuppressLint;

import androidx.annotation.Nullable;

import com.instabug.library.model.StepType;


import static com.instabug.library.model.StepType.ACTIVITY_CREATED;
import static com.instabug.library.model.StepType.ACTIVITY_DESTROYED;
import static com.instabug.library.model.StepType.ACTIVITY_PAUSED;
import static com.instabug.library.model.StepType.ACTIVITY_RESUMED;
import static com.instabug.library.model.StepType.ACTIVITY_STARTED;
import static com.instabug.library.model.StepType.ACTIVITY_STOPPED;
import static com.instabug.library.model.StepType.APPLICATION_CREATED;
import static com.instabug.library.model.StepType.DOUBLE_TAP;
import static com.instabug.library.model.StepType.FRAGMENT_ATTACHED;
import static com.instabug.library.model.StepType.FRAGMENT_DETACHED;
import static com.instabug.library.model.StepType.FRAGMENT_PAUSED;
import static com.instabug.library.model.StepType.FRAGMENT_RESUMED;
import static com.instabug.library.model.StepType.FRAGMENT_STARTED;
import static com.instabug.library.model.StepType.FRAGMENT_STOPPED;
import static com.instabug.library.model.StepType.FRAGMENT_VIEW_CREATED;
import static com.instabug.library.model.StepType.FRAGMENT_VISIBILITY_CHANGED;
import static com.instabug.library.model.StepType.LONG_PRESS;
import static com.instabug.library.model.StepType.OPEN_DIALOG;
import static com.instabug.library.model.StepType.PINCH;
import static com.instabug.library.model.StepType.SCROLL;
import static com.instabug.library.model.StepType.SHAKE;
import static com.instabug.library.model.StepType.SWIPE;
import static com.instabug.library.model.StepType.TAP;

/**
 * Created by tarek on 2/12/18.
 */

public class UserStepsMessageGenerator {

    private static String getFormattedEventName(@StepType String stepType) {

        switch (stepType) {
            case TAP:
                return "Tap";

            case DOUBLE_TAP:
                return "Double tap";

            case LONG_PRESS:
                return "Long press";

            case SCROLL:
                return "Scroll";

            case SWIPE:
                return "Swipe";

            case PINCH:
                return "Pinch";

            default:
                return "";
        }


    }

    public static String generateUserActionStepMessage(@StepType String stepType, String
            viewClassName, @Nullable String viewNameResource, @Nullable String viewText, String holderName) {

        StringBuilder stringBuilder = new StringBuilder();
        switch (stepType) {
            case TAP:
            case DOUBLE_TAP:
            case LONG_PRESS:
            case SCROLL:
            case SWIPE:
                stringBuilder.append(getFormattedEventName(stepType));
                stringBuilder.append(" in ");

                if (viewText != null && !viewText.isEmpty()) {
                    stringBuilder.append("\"");
                    stringBuilder.append(viewText);
                    stringBuilder.append("\"");
                    stringBuilder.append(" of type \"");
                    stringBuilder.append(viewClassName);
                    stringBuilder.append("\"");
                } else if (viewNameResource != null) {
                    stringBuilder.append("\"");
                    stringBuilder.append(viewNameResource);
                    stringBuilder.append("\"");
                    stringBuilder.append(" of type \"");
                    stringBuilder.append(viewClassName);
                    stringBuilder.append("\"");
                } else {
                    stringBuilder.append("\"");
                    stringBuilder.append(viewClassName);
                    stringBuilder.append("\"");
                }

                stringBuilder.append(" in \"");
                stringBuilder.append(holderName);
                stringBuilder.append("\"");
                break;

            case PINCH:
                stringBuilder.append("Pinch in ");
                stringBuilder.append(holderName);
                break;

            case SHAKE:
                stringBuilder.append("The user shook the phone in ");
                stringBuilder.append(holderName);
                break;

        }
        return stringBuilder.toString();
    }

    public static String generateActivityLifecycleStepMessage(@StepType String stepType,
                                                              String holderName) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (stepType) {
            case APPLICATION_CREATED:
            case ACTIVITY_CREATED:
                stringBuilder.append(holderName);
                stringBuilder.append(" was created.");
                break;
            case ACTIVITY_STARTED:
                stringBuilder.append(holderName);
                stringBuilder.append(" was started.");
                break;
            case ACTIVITY_RESUMED:
                stringBuilder.append(holderName);
                stringBuilder.append(" was resumed.");
                break;
            case ACTIVITY_PAUSED:
                stringBuilder.append(holderName);
                stringBuilder.append(" was paused.");
                break;
            case ACTIVITY_STOPPED:
                stringBuilder.append(holderName);
                stringBuilder.append(" was stopped.");
                break;
            case ACTIVITY_DESTROYED:
                stringBuilder.append(holderName);
                stringBuilder.append(" was destroyed.");
                break;
            case OPEN_DIALOG:
                stringBuilder.append("In container ");
                stringBuilder.append(holderName);
                stringBuilder.append(": dialog ");
                stringBuilder.append(holderName);
                stringBuilder.append(" was displayed.");
                break;

        }
        return stringBuilder.toString();

    }

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public static String generateFragmentLifecycleStepMessage(@StepType String stepType,
                                                              String holderName,
                                                              String holderParentName,
                                                              @Nullable String extraInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (stepType) {
            case OPEN_DIALOG:
                stringBuilder.append("In container ");
                stringBuilder.append(holderName);
                stringBuilder.append(": dialog ");
                stringBuilder.append(holderName);
                stringBuilder.append(" was displayed.");
                break;
            case FRAGMENT_ATTACHED:
                stringBuilder.append("In activity ");
                stringBuilder.append(holderParentName);
                stringBuilder.append(": fragment ");
                stringBuilder.append(holderName);
                stringBuilder.append(" was attached.");
                break;
            case FRAGMENT_VIEW_CREATED:
                stringBuilder.append("In activity ");
                stringBuilder.append(holderParentName);
                stringBuilder.append(": fragment ");
                stringBuilder.append(holderName);
                stringBuilder.append(" was created.");
                break;
            case FRAGMENT_STARTED:
                stringBuilder.append("In activity ");
                stringBuilder.append(holderParentName);
                stringBuilder.append(": fragment ");
                stringBuilder.append(holderName);
                stringBuilder.append(" was started.");

                break;
            case FRAGMENT_RESUMED:
                stringBuilder.append("In activity ");
                stringBuilder.append(holderParentName);
                stringBuilder.append(": fragment ");
                stringBuilder.append(holderName);
                stringBuilder.append(" was resumed.");
                break;
            case FRAGMENT_PAUSED:
                stringBuilder.append("In activity ");
                stringBuilder.append(holderParentName);
                stringBuilder.append(": fragment ");
                stringBuilder.append(holderName);
                stringBuilder.append(" was paused.");
                break;
            case FRAGMENT_STOPPED:
                stringBuilder.append("In activity ");
                stringBuilder.append(holderParentName);
                stringBuilder.append(": fragment ");
                stringBuilder.append(holderName);
                stringBuilder.append(" was stopped.");
                break;
            case FRAGMENT_DETACHED:
                stringBuilder.append("In activity ");
                stringBuilder.append(holderParentName);
                stringBuilder.append(": fragment ");
                stringBuilder.append(holderName);
                stringBuilder.append(" was detached.");
                break;
            case FRAGMENT_VISIBILITY_CHANGED:
                stringBuilder.append("In activity ");
                stringBuilder.append(holderParentName);
                stringBuilder.append(": visibility of fragment ");
                stringBuilder.append(holderName);
                stringBuilder.append(" changed, ");
                stringBuilder.append(extraInfo);
                stringBuilder.append(".");
                break;
        }
        return stringBuilder.toString();
    }
}
