package com.instabug.library.tracking;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;

public class InstabugScreenOffEventMonitor extends BroadcastReceiver implements ScreenOffEventMonitor {

    private final Context appContext;
    @Nullable
    private ScreenOffEventListener screenOffListener;

    public InstabugScreenOffEventMonitor(Context appContext) {
        this.appContext = appContext;
    }

    @Override
    public void registerListener(@NonNull ScreenOffEventListener screenOffListener) {
        if (this.screenOffListener == null) {
            IntentFilter filter = new IntentFilter(Intent.ACTION_SCREEN_OFF);
            appContext.registerReceiver(this, filter);
        }
        this.screenOffListener = screenOffListener;
    }

    @Override
    public void unRegisterListener() {
        if (this.screenOffListener != null) {
            screenOffListener = null;
            try {
                appContext.unregisterReceiver(this);
            } catch (Exception exc) {
                InstabugSDKLogger.e(Constants.LOG_TAG, "couldn't unregister Screen off receiver", exc);
            }
        }
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        if (Intent.ACTION_SCREEN_OFF.equals(intent.getAction()) && screenOffListener != null) {
            screenOffListener.onScreenOff();
        }
    }
}
