package com.instabug.library.sessionreplay

import com.instabug.library.logscollection.LogReceiver
import com.instabug.library.sessionreplay.di.SessionReplayServiceLocator
import com.instabug.library.sessionreplay.model.SRLog

interface SRLogReceiver<T : SRLog> : LogReceiver<T> {
   companion object Factory {
        /**
         * A method factory returns a new instance of [StoreSRLogReceiver]. Gets handy when
         * [SRLogStore] instance is not visible to the creator side.
         * @param store the [SRLogStore] to use when receiving.
         * @return A new instance of [StoreSRLogReceiver]
         */
        @JvmStatic
        @JvmOverloads
        fun <T : SRLog> createStoreLogReceiver(
            store: SRLogStore = SessionReplayServiceLocator.sessionReplayLogStore
        ) = StoreSRLogReceiver<T>(store)
    }
}

/**
 * A realization of the [SRLogReceiver] contract. When receiving a new [SRLog], the receiver
 * delegates its operations to an instance of [SRLogStore] to store the log received.
 */
class StoreSRLogReceiver<T : SRLog>(private val store: SRLogStore) : SRLogReceiver<T> {
    override fun invoke(log: T) {
        store(log)
    }
}