package com.instabug.library.sessionV3.manager

import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventPublisher
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent
import com.instabug.library.model.common.Session
import com.instabug.library.model.v3Session.IBGSessionState


interface IBGSessionStateManager {
    val currentSession: Session?
    fun handleStateChanged(state: IBGSessionState)
}

object IBGSessionStateManagerImpl : IBGSessionStateManager {
    @JvmStatic
    @Volatile
    private var currentState: IBGSessionState? = null

    override val currentSession: Session?
        get() = synchronized(this) {
            when (val state = currentState) {
                is IBGSessionState.Started -> state.session
                else -> null
            }
        }

    override fun handleStateChanged(state: IBGSessionState) = synchronized(this) {
        currentState = state
        sendCoreEvent(state)
    }

    private fun sendCoreEvent(state: IBGSessionState) {
        when (state) {
            is IBGSessionState.Started -> sendSessionStartedCoreEvent()
            IBGSessionState.Finished -> sendSessionFinishedCoreEvent()
        }
    }

    private fun sendSessionStartedCoreEvent() {
        IBGCoreEventPublisher.post(IBGSdkCoreEvent.V3Session.V3SessionStarted)
    }

    private fun sendSessionFinishedCoreEvent() {
        IBGCoreEventPublisher.post(IBGSdkCoreEvent.V3Session.V3SessionFinished)
    }

}


