package com.instabug.library.screenshot.analytics

import androidx.annotation.StringDef
import com.instabug.library.screenshot.analytics.ScreenshotsErrorCodes.Companion.BR_REPRO_STEPS_DISABLED_SDK
import com.instabug.library.screenshot.analytics.ScreenshotsErrorCodes.Companion.BR_RSA_DISABLED_BE
import com.instabug.library.screenshot.analytics.ScreenshotsErrorCodes.Companion.BR_SCREENSHOTS_DISABLED_SDK
import com.instabug.library.screenshot.analytics.ScreenshotsErrorCodes.Companion.CR_REPRO_STEPS_DISABLED_SDK
import com.instabug.library.screenshot.analytics.ScreenshotsErrorCodes.Companion.CR_RSA_DISABLED_BE
import com.instabug.library.screenshot.analytics.ScreenshotsErrorCodes.Companion.CR_SCREENSHOTS_DISABLED_SDK
import com.instabug.library.screenshot.analytics.ScreenshotsErrorCodes.Companion.LOW_MEMORY
import com.instabug.library.screenshot.analytics.ScreenshotsErrorCodes.Companion.NO_STORAGE
import com.instabug.library.screenshot.analytics.ScreenshotsErrorCodes.Companion.REPRO_STEPS_DISABLED_BE
import com.instabug.library.screenshot.analytics.ScreenshotsErrorCodes.Companion.UNKNOWN_EXCEPTION

@StringDef(
    NO_STORAGE,
    LOW_MEMORY,
    UNKNOWN_EXCEPTION,
    BR_RSA_DISABLED_BE,
    CR_RSA_DISABLED_BE,
    REPRO_STEPS_DISABLED_BE,
    BR_SCREENSHOTS_DISABLED_SDK,
    CR_SCREENSHOTS_DISABLED_SDK,
    BR_REPRO_STEPS_DISABLED_SDK,
    CR_REPRO_STEPS_DISABLED_SDK
)
@Retention(AnnotationRetention.SOURCE)
annotation class ScreenshotsErrorCodes {
    companion object {
        //bug reporting error codes
        const val BR_REPRO_STEPS_DISABLED_SDK = "5881"
        const val BR_SCREENSHOTS_DISABLED_SDK = "5861"
        const val BR_RSA_DISABLED_BE = "5851" //Repro steps screenshots disabled BE side for bug reporting

        //crash error codes
        const val CR_SCREENSHOTS_DISABLED_SDK = "5862"
        const val CR_REPRO_STEPS_DISABLED_SDK = "5882"
        const val CR_RSA_DISABLED_BE = "5852" //Repro steps screenshots disabled BE side for crash reporting
        const val UNKNOWN_EXCEPTION = "583"
        const val REPRO_STEPS_DISABLED_BE = "587"
        const val NO_STORAGE = "581"
        const val LOW_MEMORY = "582"
    }
}