package com.instabug.library.percentagefeatures

import com.instabug.library.util.MathUtils

fun PercentageFeature.isResolved() =
    !(sdkValue == 0.0 || beValue == 0.0)

fun PercentageFeature.resolvePercentages(newBeValue: Double = beValue) {
    if (!isResolved()) {
        resolveSdkPercentage()
    }
    beValue = newBeValue
}

private fun PercentageFeature.resolveSdkPercentage() {
    sdkValue = MathUtils.generateRandomNumber(1.0)
}
