package com.instabug.library.networkv2.service.synclogs;

import static com.instabug.library.networkv2.request.Request.BASIC_AUTH_VALUE_PREFIX;

import android.util.Base64;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;

import com.instabug.library.networkv2.request.Endpoints;
import com.instabug.library.networkv2.request.FileToUpload;
import com.instabug.library.networkv2.request.Header;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestMethod;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.networkv2.request.RequestType;

import java.io.File;
import java.io.UnsupportedEncodingException;

class SyncLogRequestMapper {

    private static final String AUTHORIZATION_SEPARATOR = ":";
    private static final String LOG_FILE_TYPE = "file";
    private static final String FILE_PART_NAME = "log_file";
    private static final String APP_TOKEN_KEY = "app_token";


    /**
     * A method to create a new request
     *
     * @param file
     * @param uuid
     * @param email
     * @return
     * @throws UnsupportedEncodingException
     */
    Request getRequest(@NonNull File file, @Nullable String uuid, @Nullable String email,
                       @NonNull String appToken)
            throws UnsupportedEncodingException {
        return new Request.Builder()
                .url(Endpoints.PRODUCTION_LOGS_URL)
                .type(RequestType.MULTI_PART)
                .method(RequestMethod.POST)
                .tokenProvider(() -> appToken)
                .fileToUpload(new FileToUpload(FILE_PART_NAME, file.getName(), file.getAbsolutePath(), LOG_FILE_TYPE))
                .addParameter(new RequestParameter(APP_TOKEN_KEY, appToken))
                .addHeader(new RequestParameter(Header.AUTHORIZATION, getAuthorizationHeader(uuid, email)))
                .build();
    }

    /**
     * A method to get authorization header
     *
     * @param uuid
     * @param email
     * @return
     * @throws UnsupportedEncodingException
     */
    @NonNull
    @VisibleForTesting
    String getAuthorizationHeader(@Nullable String uuid, @Nullable String email) throws UnsupportedEncodingException {
        email = email == null ? "null" : email;
        uuid = uuid == null ? "null" : uuid;
        String authorization = email.concat(AUTHORIZATION_SEPARATOR).concat(uuid);
        byte[] authorizationBytes = authorization.getBytes("UTF-8");
        String authorizationEncoded = Base64.encodeToString(authorizationBytes, Base64.NO_WRAP);
        return BASIC_AUTH_VALUE_PREFIX.concat(authorizationEncoded);
    }


}
