package com.instabug.library.networkv2.request;

import android.net.Uri;

import androidx.annotation.NonNull;

/**
 * Wrapper for @{@link android.net.Uri.Builder} to be
 * able to mock its usage in unit test
 */
public class UriWrapper {

    public static class Builder {
        private Uri.Builder builder;

        public static Builder getInstance() {
            return new Builder();
        }


        private Builder() {
            builder = new Uri.Builder();
        }

        public void appendQueryParameter(String key, String value) {
            builder.appendQueryParameter(key, value);
        }

        @NonNull
        @Override
        public String toString() {
            return builder.toString();
        }
    }
}
