package com.instabug.library.networkv2;

import androidx.annotation.NonNull;

import com.instabug.library.IBGNetworkWorker;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestType;

import io.reactivexport.Observable;
import io.reactivexport.ObservableEmitter;
import io.reactivexport.ObservableOnSubscribe;


/**
 * This class is used as a wrapper on top of {@link NetworkManager} to wrap network requests response in Rx Observables
 */
public class ReactiveNetworkManager {

    private final NetworkManager networkManager = new NetworkManager();


    public Observable<RequestResponse> doRequest(@RequestType final int requestType, @NonNull final Request request) {
        if (networkManager.getOnDoRequestListener() != null)
            networkManager.getOnDoRequestListener().onRequestStarted(request);

        return Observable.create(new ObservableOnSubscribe<RequestResponse>() {

            @Override
            public void subscribe(@io.reactivexport.annotations.NonNull final ObservableEmitter<RequestResponse> emitter) throws Exception {
                networkManager.doRequest(IBGNetworkWorker.CORE, requestType, request, new Request.Callbacks<RequestResponse, Throwable>() {
                    @Override
                    public void onSucceeded(RequestResponse response) {
                        emitter.onNext(response);
                        emitter.onComplete();
                    }

                    @Override
                    public void onFailed(Throwable error) {
                        emitter.tryOnError(error);
                    }
                });
            }
        });
    }
}