package com.instabug.library.model.session.config;

import static com.instabug.library.model.session.config.SyncMode.BATCHING;
import static com.instabug.library.model.session.config.SyncMode.DECOMMISSION;
import static com.instabug.library.model.session.config.SyncMode.NO_BATCHING;
import static com.instabug.library.model.session.config.SyncMode.OFF;

import androidx.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Retention(RetentionPolicy.SOURCE)
@IntDef({OFF, NO_BATCHING, BATCHING, DECOMMISSION})
public @interface SyncMode {

    int OFF = 0;
    int NO_BATCHING = 1;
    int BATCHING = 2;
    int DECOMMISSION = 3;
}
