package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract
import com.instabug.library.internal.storage.cache.dbv2.IBGEncryptedDbVersions

class DBMigrationV15(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {
    override val previous: BaseDbMigration? by lazy { DBMigrationV14(db) }
    override val version: Int
        get() = IBGEncryptedDbVersions.DB_V15

    override fun execute() =
        runLogic {
            db.execSQL(IBGDbContract.FeaturesFlagsEntry.CREATE_TABLE_QUERY)
            db.execSQL(IBGDbContract.SessionFeaturesFlagsEntry.CREATE_TABLE)
        }
}