package com.instabug.library.internal.storage.cache.dbv2;

import android.provider.BaseColumns;

/**
 * Created by mNagy on 12/15/16.
 */

public class IBGDbContract {

    public static final String TEXT_TYPE = " TEXT";
    public static final String INTEGER_TYPE = " INTEGER";
    public static final String BOOLEAN_TYPE = " BOOLEAN";
    public static final String COMMA_SEP = ",";
    public static final String DEFAULT = " DEFAULT ";
    private static final String CONSTRAINT = " CONSTRAINT ";
    private static final String FOREIGN_KEY = " FOREIGN KEY ";
    public static final String BLOB_TYPE = " BLOB";
    public static final String UNIQUE = " UNIQUE ";
    public static final String CREATE_TABLE_STATEMENT = "CREATE TABLE IF NOT EXISTS ";
    public static final String PRIMARY_KEY = " PRIMARY KEY ";
    public static final String AUTO_INCREMENT = " AUTOINCREMENT ";
    public static final String NOT_NULL = " NOT NULL";
    public static final String NULL = " NULL ";

    public static final String DELETE_STATEMENT = "DELETE FROM ";
    public static final String DROP_STATEMENT = "DROP TABLE IF EXISTS ";

    private IBGDbContract() {
    }

    public static class BugEntry implements BaseColumns {
        public static final String TABLE_NAME = "bugs_table";

        public static final String COLUMN_ID = "id";
        public static final String COLUMN_TEMPORARY_SERVER_TOKEN = "temporary_server_token";
        public static final String COLUMN_TYPE = "type";
        public static final String COLUMN_MESSAGE = "message";
        public static final String COLUMN_STATE = "state";
        public static final String COLUMN_BUG_STATE = "bug_state";
        public static final String COLUMN_VIEW_HIERARCHY = "view_hierarchy";
        public static final String COLUMN_CATEGORIES_LIST = "categories_list";
        public static final String COLUMN_CONNECTION_ERROR = "connection_error";
        public static final String COLUMN_ACTIONABLE_CONSENT = "actionable_consent";
        public static final String COLUMN_FRUSTRATING_EXPERIENCE_INTERNAL_ID = "initial_frustrating_experience_id";
        public static final String COLUMN_FRUSTRATING_EXPERIENCE_EXTERNAL_ID = "backend_frustrating_experience_id";

        // CREATE bugs table
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME +
                        " ( " + COLUMN_ID + TEXT_TYPE + " PRIMARY KEY"
                        + COMMA_SEP
                        + COLUMN_TEMPORARY_SERVER_TOKEN + TEXT_TYPE
                        + COMMA_SEP
                        + COLUMN_TYPE + TEXT_TYPE
                        + COMMA_SEP
                        + COLUMN_MESSAGE + TEXT_TYPE
                        + COMMA_SEP
                        + COLUMN_STATE + TEXT_TYPE
                        + COMMA_SEP
                        + COLUMN_BUG_STATE + TEXT_TYPE
                        + COMMA_SEP
                        + COLUMN_VIEW_HIERARCHY + TEXT_TYPE
                        + COMMA_SEP
                        + COLUMN_CATEGORIES_LIST + TEXT_TYPE
                        + COMMA_SEP
                        + COLUMN_CONNECTION_ERROR + TEXT_TYPE + DEFAULT + "NULL"
                        + COMMA_SEP
                        + COLUMN_ACTIONABLE_CONSENT + TEXT_TYPE + DEFAULT + "NULL"
                        + COMMA_SEP
                        + COLUMN_FRUSTRATING_EXPERIENCE_INTERNAL_ID + INTEGER_TYPE
                        + COMMA_SEP
                        + COLUMN_FRUSTRATING_EXPERIENCE_EXTERNAL_ID + TEXT_TYPE + DEFAULT + "NULL"
                        + " )";

        // DROP attachments table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class FatalHangEntry implements BaseColumns {
        public static final String TABLE_NAME = "fatal_hangs_table";

        public static final String COLUMN_ID = "id";
        public static final String COLUMN_TEMPORARY_SERVER_TOKEN = "temporary_server_token";
        public static final String COLUMN_MESSAGE = "message";
        public static final String COLUMN_STATE = "state";
        public static final String COLUMN_FATAL_HANG_STATE = "fatal_hang_state";
        public static final String COLUMN_MAIN_THREAD_DETAIL = "main_thread_details";
        public static final String COLUMN_THREADS_DETAILS = "threads_details";
        public static final String COLUMN_LAST_ACTIVITY = "last_activity";
        public static final String COLUMN_UUID = "uuid";

        // CREATE Fatal hangs table
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME +
                        " ( " + COLUMN_ID + TEXT_TYPE + COMMA_SEP
                        + COLUMN_TEMPORARY_SERVER_TOKEN + TEXT_TYPE + COMMA_SEP
                        + COLUMN_MESSAGE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_FATAL_HANG_STATE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_STATE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_MAIN_THREAD_DETAIL + TEXT_TYPE + COMMA_SEP
                        + COLUMN_THREADS_DETAILS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_LAST_ACTIVITY + TEXT_TYPE + COMMA_SEP
                        + COLUMN_UUID + TEXT_TYPE + DEFAULT + "NULL" + ")";

        // DROP Fatal hangs table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class AppTerminationEntry implements BaseColumns {
        public static final String TABLE_NAME = "terminations_table";

        public static final String COLUMN_ID = "id";
        public static final String COLUMN_TEMPORARY_SERVER_TOKEN = "temporary_server_token";
        public static final String COLUMN_STATE = "state";
        public static final String COLUMN_TERMINATION_STATE = "termination_state";
        public static final String COLUMN_LAST_ACTIVITY = "last_activity";
        public static final String COLUMN_UUID = "uuid";

        // CREATE Fatal hangs table
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME +
                        " ( " + COLUMN_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_TEMPORARY_SERVER_TOKEN + TEXT_TYPE + COMMA_SEP
                        + COLUMN_TERMINATION_STATE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_STATE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_UUID + TEXT_TYPE + DEFAULT + "NULL" + ")";

        // DROP Fatal hangs table
        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;
        // Clear table's recorders
        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
    }

    public static class SessionEntry implements BaseColumns {
        public static final String TABLE_NAME = "session_table";
        public static final String COLUMN_SERIAL = "session_serial";
        public static final String COLUMN_ID = "session_id";
        public static final String COLUMN_FOREGROUND_START_TIME = "foreground_start_time";
        public static final String COLUMN_NANO_START_TIME = "nano_start_time";
        public static final String COLUMN_BACKGROUND_START_TIME = "background_start_time";
        public static final String COLUMN_DURATION = "duration";
        public static final String COLUMN_USER_EVENTS = "user_events";
        public static final String COLUMN_USER_ATTRIBUTES = "user_attributes";
        public static final String COLUMN_USER_EMAIL = "user_email";
        public static final String COLUMN_USER_NAME = "user_name";
        public static final String COLUMN_UUID = "uuid";
        public static final String COLUMN_APP_TOKEN = "app_token";
        public static final String COLUMN_OS = "os";
        public static final String COLUMN_DEVICE = "device";
        public static final String COLUMN_SDK_VERSION = "sdk_version";
        public static final String COLUMN_APP_VERSION = "app_version";
        public static final String COLUMN_SYNC_STATUS = "sync_status";
        public static final String COLUMN_USERS_PAGE_ENABLED = "users_page_enabled";
        public static final String COLUMN_V2_SESSION_SENT = "v2_session_sent";
        public static final String COLUMN_PRODUCTION_USAGE = "production_usage";
        public static final String COLUMN_SESSION_STITCHING_STATE = "stitching_state";
        public static final String COLUMN_SESSION_RANDOM_ID = "session_random_id";
        public static final String COLUMN_LOCALE = "locale";
        public static final String COLUMN_SCREEN_SIZE = "screen_size";
        public static final String COLUMN_RATING_DIALOG_DETECTION = "rating_dialog_detection";
        public static final String COLUMN_SR_ENABLED = "sr_enabled";
        public static final String COLUMN_SR_EVALUATED = "sr_evaluated";
        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME +
                        " ( "
                        + COLUMN_SERIAL + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_ID + TEXT_TYPE + COMMA_SEP
                        + COLUMN_FOREGROUND_START_TIME + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_BACKGROUND_START_TIME + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_NANO_START_TIME + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_DURATION + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_USER_ATTRIBUTES + TEXT_TYPE + COMMA_SEP
                        + COLUMN_USER_EVENTS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_USER_EMAIL + TEXT_TYPE + COMMA_SEP
                        + COLUMN_UUID + TEXT_TYPE + COMMA_SEP
                        + COLUMN_USER_NAME + TEXT_TYPE + COMMA_SEP
                        + COLUMN_OS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_APP_TOKEN + TEXT_TYPE + COMMA_SEP
                        + COLUMN_DEVICE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SDK_VERSION + TEXT_TYPE + COMMA_SEP
                        + COLUMN_APP_VERSION + TEXT_TYPE + COMMA_SEP
                        + COLUMN_USERS_PAGE_ENABLED + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_V2_SESSION_SENT + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_SYNC_STATUS + TEXT_TYPE + COMMA_SEP
                        + COLUMN_PRODUCTION_USAGE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SESSION_RANDOM_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_LOCALE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SCREEN_SIZE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SESSION_STITCHING_STATE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_RATING_DIALOG_DETECTION + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SR_ENABLED + INTEGER_TYPE + DEFAULT + " 0" + COMMA_SEP
                        + COLUMN_SR_EVALUATED + INTEGER_TYPE + DEFAULT + " 1" + " )";

        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;

        public static final String DELETE_ALL = "DELETE FROM " + TABLE_NAME;
        public static final String TRIM_WHERE_CLAUSE = COLUMN_SERIAL + " IN ( SELECT "
                + COLUMN_SERIAL + " FROM " + TABLE_NAME +
                " ORDER BY " + COLUMN_SERIAL + " DESC limit ? OFFSET ? )";
    }

    public static class SessionExperimentEntry {
        public static final String TABLE_NAME = "session_experiment_table";
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_EXPERIMENT_ARRAY = "experiment_array";
        public static final String COLUMN_DROPPED_COUNT = "experiments_dropped_count";
        public static final String COLUMN_SESSION_SERIAL = "session_serial";
        public static final String SESSION_SERIAL_FOREIGN_KEY_CONSTRAINT_NAME = "session_serial_foreign_key";

        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY AUTOINCREMENT" + COMMA_SEP
                        + COLUMN_EXPERIMENT_ARRAY + TEXT_TYPE + COMMA_SEP
                        + COLUMN_SESSION_SERIAL + INTEGER_TYPE + UNIQUE + COMMA_SEP
                        + COLUMN_DROPPED_COUNT + INTEGER_TYPE + COMMA_SEP
                        + CONSTRAINT + SESSION_SERIAL_FOREIGN_KEY_CONSTRAINT_NAME
                        + FOREIGN_KEY + "(" + COLUMN_SESSION_SERIAL + ") REFERENCES "
                        + SessionEntry.TABLE_NAME + "(" + SessionEntry.COLUMN_SERIAL + ") "
                        + "ON DELETE CASCADE"
                        + " )";

        public static final String DROP_TABLE_QUERY =
                "DROP TABLE IF EXISTSon " + TABLE_NAME;

    }

    public static class SessionFeaturesFlagsEntry {
        public static final String TABLE_NAME = "session_features_flags_table";
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_SESSION_SERIAL = "session_serial";
        public static final String COLUMN_FEATURES_FLAGS_ARRAY = "features_flags_array";
        public static final String SESSION_SERIAL_FOREIGN_KEY_CONSTRAINT_NAME = "session_serial_foreign_key";

        public static final String CREATE_TABLE = CREATE_TABLE_STATEMENT + TABLE_NAME + " ( "
                + COLUMN_ID + INTEGER_TYPE + PRIMARY_KEY + AUTO_INCREMENT + COMMA_SEP
                + COLUMN_SESSION_SERIAL + INTEGER_TYPE + UNIQUE + COMMA_SEP
                + COLUMN_FEATURES_FLAGS_ARRAY + TEXT_TYPE + COMMA_SEP
                + CONSTRAINT + SESSION_SERIAL_FOREIGN_KEY_CONSTRAINT_NAME
                + FOREIGN_KEY + "(" + COLUMN_SESSION_SERIAL + ") REFERENCES "
                + SessionEntry.TABLE_NAME + "(" + SessionEntry.COLUMN_SERIAL + ") "
                + "ON DELETE CASCADE" + ");";

        public static final String DROP_TABLE_QUERY = DROP_STATEMENT + TABLE_NAME;
    }

    public static class SessionIncidentEntry {
        public static final String TABLE_NAME = "session_incident";
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_SESSION_ID = "session_id";
        public static final String COLUMN_INCIDENT_ID = "incident_id";
        public static final String COLUMN_INCIDENT_TYPE = "incident_type";
        public static final String COLUMN_VALIDATION_STATUS = "validation_status";

        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_SESSION_ID + TEXT_TYPE + COMMA_SEP
                        + COLUMN_INCIDENT_ID + TEXT_TYPE + COMMA_SEP
                        + COLUMN_INCIDENT_TYPE + TEXT_TYPE + COMMA_SEP
                        + COLUMN_VALIDATION_STATUS + INTEGER_TYPE + DEFAULT + "0" + " )";

        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;

        public static final String TRIM_WHERE_CLAUSE = COLUMN_ID + " IN ( SELECT "
                + COLUMN_ID + " FROM " + TABLE_NAME
                + " WHERE " + COLUMN_SESSION_ID + " = ? AND " + COLUMN_INCIDENT_TYPE + " = ?"
                + " ORDER BY " + COLUMN_ID + " DESC limit ? OFFSET ? )";
    }

    public static class SessionReplayMetadataEntry {
        public static final String TABLE_NAME = "session_replay_metadata";
        public static final String COLUMN_ID = "suuid";
        public static final String COLUMN_START_TIME = "start_time";
        public static final String COLUMN_PARTIAL_ID = "partial_id";
        public static final String COLUMN_STATUS = "status";

        public static final String CREATE_TABLE =
                "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " ( "
                        + COLUMN_ID + TEXT_TYPE + COMMA_SEP
                        + COLUMN_START_TIME + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_PARTIAL_ID + INTEGER_TYPE + COMMA_SEP
                        + COLUMN_STATUS + TEXT_TYPE + " )";

        public static final String DROP_TABLE =
                "DROP TABLE IF EXISTS " + TABLE_NAME;

        public static final String DELETE_ALL =
                "DELETE FROM " + TABLE_NAME;
    }

    //create new schema for features flags Table
    public static class FeaturesFlagsEntry implements BaseColumns {
        public static final String TABLE_NAME = "features_flags";
        public static final String COLUMN_ID = "features_flags_id";
        public static final String FEATURES_FLAGS_COLUMN_KEY = "features_flags_key";
        public static final String FEATURES_FLAGS_COLUMN_VALUE = "features_flags_value";
        //Queries
        public static final String CREATE_TABLE_QUERY =
                CREATE_TABLE_STATEMENT + TABLE_NAME + " ( "
                        + COLUMN_ID + INTEGER_TYPE + PRIMARY_KEY + AUTO_INCREMENT + COMMA_SEP
                        + FEATURES_FLAGS_COLUMN_KEY + TEXT_TYPE + NOT_NULL + COMMA_SEP
                        + FEATURES_FLAGS_COLUMN_VALUE + TEXT_TYPE + NULL + COMMA_SEP +
                        UNIQUE + "(" + FEATURES_FLAGS_COLUMN_KEY + ") ON CONFLICT IGNORE" + ");";

        public static final String DROP_TABLE_QUERY = DROP_STATEMENT + TABLE_NAME;
        public static final String DELETE_ALL = DELETE_STATEMENT + TABLE_NAME;

    }
}
