package com.instabug.library.internal.storage.cache.db.migrations;

import android.database.sqlite.SQLiteDatabase;

import com.instabug.library.internal.storage.cache.db.InstabugDBVersions;
import com.instabug.library.internal.storage.cache.db.InstabugDbContract;
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.UserEntity;

/**
 * Allows the database to migrate from version 12 to version 14
 * <p>
 * Schemas are defined in {@link InstabugDbContract}. Any changes to these schemas will require
 * a migration.
 *
 * @see InstabugDBVersions
 */
public class Migration_12_14 implements Migration {

    @Override
    public void migrate(SQLiteDatabase db) {
        db.execSQL("ALTER TABLE " + UserEntity.TABLE_NAME
                + " ADD COLUMN " + UserEntity.COLUMN_LAST_SEEN + " INTEGER"
                + " DEFAULT 0");
    }
}
