package com.instabug.library.internal.storage.cache.db.migrations;

import android.database.sqlite.SQLiteDatabase;

import androidx.annotation.NonNull;

import com.instabug.library.internal.storage.cache.db.InstabugDBVersions;
import com.instabug.library.internal.storage.cache.db.InstabugDbContract;

/**
 * A migration that can handle more than 1 version (e.g. migrate from 3 to 4 and 4 to 5).
 * If there are no migrations provided it will fallback to a {@link DestructiveMigration}
 * <p>
 * Schemas are defined in {@link InstabugDbContract}. Any changes to these schemas will require
 * a migration.
 *
 * @see InstabugDBVersions
 */
public class CompositeMigration implements Migration {

    private final Migration[] migrations;

    public CompositeMigration(@NonNull Migration... migrations) {
        this.migrations = migrations;
    }

    @Override
    public void migrate(@NonNull SQLiteDatabase db) {
        if (migrations.length == 0) {
            new DestructiveMigration().migrate(db);
        } else {
            for (Migration migration : migrations) {
                migration.migrate(db);
            }
        }
    }
}
