package com.instabug.library.internal.orchestrator;

import com.instabug.library.logging.UserEventsDbHelper;
import com.instabug.library.user.UserManager;

import java.util.Map;

public class MigrateAnonymousUserEventsAction implements Action {

    private final String uuid;

    public MigrateAnonymousUserEventsAction(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public void run() throws Exception {
        Map<String, Integer> userEvents = UserEventsDbHelper.retrieveAllAnonymous();
        for (Map.Entry<String, Integer> entry : userEvents.entrySet()) {
            String identifier = entry.getKey();
            int count = entry.getValue();
            // migrate new user event only, existing ones remains with same values
            if (!UserEventsDbHelper.exists(identifier, uuid)) {
                UserEventsDbHelper.insertOrUpdate(identifier, count, uuid, !UserManager.isLoggedIn());
            }
        }
        UserEventsDbHelper.deleteAllAnonymous();
    }
}
