package com.instabug.library.internal.orchestrator;

import com.instabug.library.internal.storage.cache.user.UserCacheManager;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.user.UserManager;

public class LogoutUserAction implements Action {
    final String newUUID;

    /**
     * @param newUUID will replace the old uuid after logout
     */
    public LogoutUserAction(String newUUID) {
        this.newUUID = newUUID;
    }

    @Override
    public void run() throws Exception {
        SettingsManager.getInstance().resetSessionCount();
        SettingsManager.getInstance().setUserLoggedOut(true);
        SettingsManager.getInstance().setUuid(newUUID);
        SettingsManager.getInstance().setMD5Uuid(null);
        UserManager.setIdentifiedUserEmail("");
        UserManager.setIdentifiedUsername("");
        SettingsManager.getInstance().setShouldMakeUUIDMigrationRequest(false);
        UserManager.clearUserActivities();
        UserCacheManager.insertIfNotExists(newUUID, SettingsManager.getInstance().getSessionsCount());
    }
}
