package com.instabug.library.featuresflags

import com.instabug.library.featuresflags.constants.FFMode
import com.instabug.library.featuresflags.mappers.featuresFlagsAsJson
import com.instabug.library.model.State.KEY_EXPERIMENTS
import com.instabug.library.model.State.KEY_FEATURES_FLAGS
import com.instabug.library.model.State.StateItem
import org.json.JSONArray


class EnhancementRequestBodyParams {
    fun getModifiedStateItemsList(
        stateItems: List<StateItem<*>>?,
        @FFMode featureFlagConfigMode: Int
    ): Map<String, Any?> {
        val enhancedState = stateItems?.toMutableList()
        when (featureFlagConfigMode) {
            FFMode.DISABLED -> {
                // Remove feature flags list if any
                return enhancedState?.filter { it.key != KEY_FEATURES_FLAGS }
                    ?.filter { it.key != null }
                    ?.associate { it.key!! to it.value } ?: mapOf()
            }

            FFMode.FF -> {
                // Change the format of the featureFlags list
                enhancedState?.find { it.key == KEY_FEATURES_FLAGS }?.let { featureFlagsList ->
                    enhancedState.remove(featureFlagsList)
                    val featuresFlagsString =
                        featuresFlagsAsJson(featureFlagsList.value as JSONArray)
                    enhancedState.add(StateItem(KEY_FEATURES_FLAGS, featuresFlagsString))
                }
                return enhancedState?.associate { it.key!! to it.value } ?: mapOf()
            }

            FFMode.EXPERIMENTS -> {
                val featureFlagsList = enhancedState?.find { it.key == KEY_FEATURES_FLAGS }
                featureFlagsList?.let { ffList ->
                    //Remove feature flags state item
                    enhancedState.remove(featureFlagsList)
                    val experimentsStateItem = enhancedState.find { it.key == KEY_EXPERIMENTS }
                    if(experimentsStateItem != null) {
                        // Append feature flags to experiments JSONArray
                        (ffList.value as JSONArray).let {
                            for (i in 0 until it.length()) {
                                val jsonObject = it.getJSONObject(i)
                                val modifiedFeatureFlag =
                                    HelperMethods.formatFeaturesFlagList(jsonObject)
                                (experimentsStateItem.value as JSONArray).put(modifiedFeatureFlag)
                            }
                        }
                    } else {
                        // Create new Experiments JSONArray and add feature flags to it
                        (ffList.value as JSONArray).let {
                            val experiments = JSONArray()
                            for (i in 0 until it.length()) {
                                val jsonObject = it.getJSONObject(i)
                                val modifiedFeatureFlag =
                                    HelperMethods.formatFeaturesFlagList(jsonObject)
                                experiments.put(modifiedFeatureFlag)
                            }
                            enhancedState.add(StateItem(KEY_EXPERIMENTS, experiments))
                        }
                    }
                }
                return enhancedState?.filter { it.key != null }?.associate { it.key!! to it.value }
                    ?: mapOf()
            }

            else -> return enhancedState?.filter { it.key != null }
                ?.associate { it.key!! to it.value } ?: mapOf()
        }
    }

}
