package com.instabug.library.diagnostics.sdkEvents.cache

import com.instabug.library.diagnostics.sdkEvents.models.SDKEvent

interface SDKEventsCachingManager {

    // save event with count to database
    fun saveEvent(event: SDKEvent)

    // fetches all events at the sdk_events table
    fun getAllEvents(): List<SDKEvent>?

    /*
    * deletes every event in the collection if it has a table entry
    */
    fun deleteManyEvents(keys: Collection<String>?)

    // deletes all events at the sdk_events table
    fun clearCache()

    // calls SDKEventsDbHelper.updateSyncedRecords()
    fun updateSyncedRecords(sdkEvents: List<SDKEvent>)

    // delete events with count = 0
    fun deleteZeroCountedEvents()
}