package com.instabug.library.diagnostics.customtraces.utils

import com.instabug.library.Constants
import com.instabug.library.Instabug
import com.instabug.library.InstabugState
import com.instabug.library.InstabugStateProvider
import com.instabug.library.diagnostics.DiagnosticsConstants
import com.instabug.library.diagnostics.customtraces.settings.CustomTracesSettingsResolver
import com.instabug.library.diagnostics.isCalledInternally
import com.instabug.library.util.InstabugSDKLogger

object CustomTracesValidator {

    fun canStartTrace(stackTrace: Array<StackTraceElement?>?): Boolean {
        if (!isCalledInternally(stackTrace)) {
            InstabugSDKLogger.w(
                Constants.LOG_TAG,
                "Please refrain from using IBGDiagnostics.startTrace as it's a private api"
            )
            return false
        }
        if(CustomTracesSettingsResolver.customTracesSettings?.enabled == false) {
            InstabugSDKLogger.v(Constants.LOG_TAG, "Can't start custom trace, feature is disabled")
        }
        return CustomTracesSettingsResolver.customTracesSettings?.enabled ?: false && Instabug.isBuilt() && Instabug.isEnabled()
    }

    fun String?.toValidTraceNameOrNull(): String? =
        takeIf {
            !it.isNullOrEmpty()
        }?.let {
            val trimmed = it.trim()
            if (trimmed.length > DiagnosticsConstants.TRACE_NAME_LENGTH)
                return@let trimmed.substring(0, DiagnosticsConstants.TRACE_NAME_LENGTH)
            trimmed
        }

    fun validateTraceDuration(startTime: Long, endTime: Long): Boolean =
        startTime != 0L && endTime != 0L && endTime > startTime

    fun String.toValidAttributeKeyOrNull(): String? =
        takeIf { it.isNotEmpty() }
            ?.let {
                val trimmed = it.trim()
                if (trimmed.length > DiagnosticsConstants.TRACE_ATTRIBUTES_KEY_LENGTH) {
                    return null
                }
                trimmed
            }

    fun String.toValidAttributeValueOrNull(): String? =
            this.let {
                val trimmed = it.trim()
                if (trimmed.length > DiagnosticsConstants.TRACE_ATTRIBUTES_VALUE_LENGTH) {
                    return null
                }
                trimmed
            }

    fun shouldSaveTrace(traceName: String) : Boolean =
        when(traceName) {
            in DiagnosticsConstants.LAUNCH_TRACES -> CustomTracesSettingsResolver.customTracesSettings?.recordLaunchTrace == true
            in DiagnosticsConstants.FEATURE_TRACES -> CustomTracesSettingsResolver.customTracesSettings?.recordFeatureTrace == true
            else -> true
        }
}