package com.instabug.library.core.eventbus.eventpublisher

import java.util.*
import java.util.concurrent.ConcurrentHashMap

fun interface IBGDisposable {
    fun dispose()
}

class IBGCompositeDisposable : IBGDisposable {

    private val disposables: MutableSet<IBGDisposable> =
        Collections.newSetFromMap(ConcurrentHashMap())

    infix fun add(disposable: IBGDisposable) {
        disposables.add(disposable)
    }

    infix fun remove(disposable: IBGDisposable) {
        disposable.dispose()
        disposables.remove(disposable)
    }

    fun clear() {
        disposables
            .onEach { it.dispose() }
            .clear()
    }

    override fun dispose() {
        clear()
    }
}