package com.instabug.library.core.eventbus.eventpublisher

import com.instabug.library.internal.servicelocator.CoreServiceLocator
import java.util.concurrent.ConcurrentHashMap

open class AbstractEventPublisher<T> : EventPublisher<T> {
    private val subscribers: ConcurrentHashMap<Subscriber<T>, IBGDisposable> = ConcurrentHashMap()

    private val exceptionHandler: IBGEventBusExceptionHandler
        get() = CoreServiceLocator.eventBusExceptionHandler

    override fun post(event: T) {
        subscribers.keys.forEach { subscriber ->
            exceptionHandler.runDefensive { subscriber.onNewEvent(event) }
        }

    }

    override fun postError(throwable: Throwable) {
        subscribers.keys
            .filterIsInstance(ErrorHandlingSubscriber::class.java)
            .forEach { subscriber ->
                exceptionHandler.runDefensive { subscriber.onError(throwable) }
            }

    }

    override fun subscribe(subscriber: Subscriber<T>): IBGDisposable {
        exceptionHandler.runDefensive {
            if (subscribers[subscriber] == null)
                subscribers[subscriber] = IBGDisposable {
                    exceptionHandler.runDefensive {
                        subscribers.remove(subscriber)
                    }
                }
        }
        return subscribers[subscriber]!!
    }

}