package com.instabug.library

import java.util.*

interface SpanIDProvider {
    val spanId: String
}

/**
 * A singleton instance that keep app launch info within the scope of its lifespan.
 */
object AppLaunchIDProvider : SpanIDProvider {
    /**
     * A UUID representing identifying a single app lifespan (process lifespan)
     */
    override val spanId: String by lazy { UUID.randomUUID().toString() }
}