package com.instabug.library;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.IntDef;

/**
 * Actions Used for setting email required bug/feedback/feature-requests
 * Created by mzelzoghbi on 3/14/18.
 */
@IntDef(flag = true,
        value = {
                ActionType.ALL_ACTIONS,
                ActionType.REPORT_BUG,
                ActionType.REQUEST_NEW_FEATURE,
                ActionType.ADD_COMMENT_TO_FEATURE})
@Retention(RetentionPolicy.SOURCE)
public @interface ActionType {

    int ALL_ACTIONS = 1;
    int REPORT_BUG = 1 << 1;
    int REQUEST_NEW_FEATURE = 1 << 2;
    int ADD_COMMENT_TO_FEATURE = 1 << 3;
}
