package com.instabug.library.visualusersteps

import androidx.annotation.IntDef
import com.instabug.library.IssueType
import com.instabug.library.ReproMode
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.CrashEntry

interface ReproRuntimeConfigurationsHandler {
     fun handle(modesMap: Map<Int, Int>) {
        //No-op
    }
}

class BasicReproRuntimeConfigurationsHandler(
    @IssueType private val type: Int,
    private val reproConfigurationsProvider: ReproConfigurationsProvider
) : ReproRuntimeConfigurationsHandler {
    override fun handle(modesMap: Map<Int, Int>) {
        modesMap[type]?.let { featureMode ->
            with(reproConfigurationsProvider) {
                isReproStepsEnabledSDK = featureMode > ReproMode.Disable
                isReproScreenShotsEnabledSDK = featureMode > ReproMode.EnableWithNoScreenshots
            }
        }
    }
}

@IntDef(ReproProxyAuthID.Bugs, ReproProxyAuthID.SessionReplay,
    ReproProxyAuthID.Fatals, ReproProxyAuthID.NonFatals, ReproProxyAuthID.ANR, ReproProxyAuthID.AppHangs, ReproProxyAuthID.ForceRestarts)
annotation class ReproProxyAuthID {
    companion object {
        const val Bugs = 0x01
        const val SessionReplay = 0x03
        const val Fatals = 0x04
        const val NonFatals = 0x05
        const val ANR = 0x06
        const val AppHangs = 0x07
        const val ForceRestarts = 0x08
    }
}

interface ReproConfigurationsProvider {
    @ReproProxyAuthID
    val reproProxyAuthId: Int
    val isReproStepsEnabled: Boolean
    var isReproStepsEnabledSDK: Boolean
    val isReproScreenshotsEnabled: Boolean
    var isReproScreenShotsEnabledSDK : Boolean
    var isReproScreenshotsAvailable : Boolean
}