package com.instabug.library.util.extenstions

import com.instabug.library.internal.filestore.Directory
import java.io.File

inline fun <T : File> T.ifNotExists(block: T.() -> Unit): T = run {
    takeIf { it.exists() } ?: block(); this
}

fun <T : File> T.takeIfExists(): T? = run { takeIf { it.exists() } }

internal fun <T : File> T.takeUnlessExists(): T? = run { takeUnless { it.exists() } }

fun File.toDirectory() = parentFile?.let { Directory(it, name) }

internal fun File.mkdirDefensive() =
    runCatching { require(mkdir()) { "Couldn't create directory" } }
        .runOrLogAndReport("Failure while creating directory (mkdir)")

fun File.mkdirsDefensive() =
    runCatching { require(mkdirs()) { "Couldn't create directory" } }
        .runOrLogAndReport("Failure while creating directory (mkdirs)")

internal fun File.createNewFileDefensive() =
    runCatching { require(createNewFile()) { "Couldn't create new file" } }
        .runOrLogAndReport("Failure while creating new file")

internal fun File.deleteDefensive() =
    runCatching { require(delete()) { "Couldn't delete file/directory" } }
        .runOrLogAndReport("Failure while deleting file/directory")

fun File.deleteRecursivelyDefensive() =
    runCatching { require(deleteRecursively()) { "Couldn't delete file/directory recursively" } }
        .runOrLogAndReport("Failure while deleting file/directory recursively")