package com.instabug.library.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import androidx.annotation.NonNull;

import com.instabug.library.Constants;


public class NetworkUtils {

    @NonNull
    private final Context context;

    public NetworkUtils(@NonNull Context context) {
        this.context = context;
    }

    public boolean isOnline() {
        try {
            ConnectivityManager connectivityManager =
                    (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo activeNetworkInfo;
            if (connectivityManager != null) {
                activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
                if (activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting()) {
                    return true;
                }
            }
        } catch (SecurityException e) {
            InstabugSDKLogger.w(Constants.LOG_TAG, "Could not read network state. To enable "
                    + "please add the following line in your AndroidManifest.xml <uses-permission "
                    + "android:name=\"android.permission.ACCESS_NETWORK_STATE\"/>\n" + e.getMessage());
        } catch (Exception e) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Something went wrong while checking network state", e);
        }
        return false;
    }
}
